/*-
 * Copyright (C)2014..2025 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2014..2025 @BABOLO http://www.babolo.ru/"
#ident "@(#) $Id: recobe.c,v 1.88 2025/12/21 18:30:41 babolo Exp $"

#define BLIN_COMPAT     4
#define MIFE_COMPAT     5
#define Bpars_COMPAT    4
#define RECOBE_COMPAT   VMAJOR
#define RECOBE_INTERNAL

#include <sys/types.h>
#include <sys/event.h>
#include <sys/stat.h>
#include <sysexits.h>
#include <strings.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <fcntl.h>
#include <stdio.h>
#include <errno.h>
#include <babolo/BLINflag.h>
#include <babolo/parser.h>
#include <mife.h>
#include "lib/recobe.h"

#define RECOBE_CASE_OPTS opts
#define RECOBE_CASE_OUT  out
#define RECOBE_CASE_EX   ex

static void
/*****************************************************************************************************/
usage() {                                                                                        /****
 *****************************************************************************************************/
    fprintf( stderr
           , "recobe @BABOLO V.M "VERS"  "DATE" http://www.babolo.ru/\n"
             "Usage: recobe [-options][ infile_or_string[ oufile]]\n"
             "   -a TEXT         input text\n"
             "   -b TEXT         mark before unconverted sym, default \"?\"\n"
             "   -B TEXT         code begin marker\n"
             "   -c XY           translate byte-to-byte infile to oufile, X & Y list at -?c\n"
             "   -C              alter clear flag (off by default)\n"
             "   -e TEXT         mark after unconverted sym, default empty\n"
             "   -E TEXT         code end marker\n"
             "   -f FILE         input file\n"
             "   -F              full control log\n"
             "   -H              substXXXXsubst substitute if conversion error XXXX\n"
             "   -k CODE         convert text-to-text infile to oufile, list at -?k\n"
             "   -l              ?\n"
             "   -L              flip strict code length control\n"
             "   -m TEXT         next conversion parameter (-?m for help)\n"
             "   -M SYM          hex convert start symbol\n"
             "   -o ord          byte orer: B, L\n"
             "   -p              print printables as symbols\n"
             "   -P              fancy print\n"
             "   -q              silent\n"
             "   -s CODE         control code, list at -?s\n"
             "   -t XY[name]     print table from binary stdin\n"
             "   -T              tracing\n"
             "   -v[v[v...]]     verbose\n"
             "   -w              not yet\n"
             "   -W              not yet\n"
             "   -Y -X XX        use XX as env name for opt's arg\n"
             "   -z TEXT         parce TEXT as arguments continuation\n"
             "   -Z TEXT         parce TEXT as arguments continuation with env substitution\n"
             "   -= mode         internal diagnostic, list at -?=\n"
             "   -?              this text\n"
             "   -?c             domains and encodings list\n"
             "   -?k             k conversions list\n"
             "   -?s             control sums list\n"
             "   -?m             -m semantic\n"
             "   -?=             internal diagnostics list\n"
           )
    ;
}

static void
/*****************************************************************************************************/
usagem() {                                                                                       /****
 *****************************************************************************************************/
    fprintf( stderr
           , "For 0Q [=[ft[=ft]...[#M[$m]]]]\n"
             "       where = hex indicator and LF canseller\n"
             "             f symbol to translate from\n"
             "             t symbol to translate to\n"
             "             # some symbol not equal =\n"
             "             M number for max out string length\n"
             "             $ some symbol not equal = or digit\n"
             "             m string length cuted on space if possible\n"
             "    [0-7][DX] Single byte char up to this code\n"
           )
    ;
}

static void
/*****************************************************************************************************/
usagec() {                                                                                       /****
 *****************************************************************************************************/
    int i;
    int k;
    int m;
    int n;
    int u;

    for (i = 0; !!recobe_collection.domains[i]; i++) {
        m = 0;
        for (k = 0; k < recobe_collection.domains[i]->recountad; ++k) {
            if  (RECOBE_C & recobe_collection.domains[i]->family) {
                if  (!k) fprintf(stderr, "%s", recobe_collection.domains[i]->domname);
                if  (  !!recobe_collection.domains[i]->encolist[k].encoid
                    && !!recobe_collection.domains[i]->encolist[k].enconamess
                    ) {
                    fprintf( stderr
                           , "\t%c%s"
                           , (!m) ? ':' : ' '
                           , recobe_collection.domains[i]->encolist[k].encoid
                           )
                    ;
                    ++m;
                    u = 0;
                    for (n = 0; !!(*recobe_collection.domains[i]->encolist[k].enconamess)[n]; ++n) {
                        fprintf( stderr
                               , "%c %s"
                               , (!u) ? ' ' : ','
                               , (*recobe_collection.domains[i]->encolist[k].enconamess)[n]
                               )
                        ;
                        ++u;
                    }
                    fprintf(stderr, "\n");
    }   }   }   }
}

static void
/*****************************************************************************************************/
usages() {                                                                                       /****
 *****************************************************************************************************/
    fprintf( stderr
           , "   1  csum1\n"
             "   2  crc24\n"
             "   3  crc32\n"
             "   4  crcCCITT(16bit)\n"
             "   5  csum\n"
           )
    ;
}

static void
/*****************************************************************************************************/
usagek() {                                                                                       /****
 *****************************************************************************************************/
    fprintf( stderr
           , "    u[0-9] utf-8 to 1..10 byte unicode\n"
             "    [0-9]u 1..10 byte unicode to utf-8\n"
             "    k[0-9] koi8 to 1..10 byte unicode\n"
             "    [0-9]k 1..10 byte unicode to koi8\n"
             "    [0-9]Z swap case on 1..10 byte unicode\n"
             "    [0-9]Y upper case on 1..10 byte unicode\n"
             "    Y[0-9] lower case on 1..10 byte unicode\n"
             "    0[0-7] word size change\n"
             "[2-9][2-9] word size change\n"
             "    [0-3]p 1..4 byte unicode to punycope\n"
             "    p[0-9] punycope to 1..10 byte unicode\n"
             "    [0-3]P 1..4 byte unicode to punycope with case transformation\n"
             "    P[0-9] punycope to 1..10 byte unicode with case transformation\n"
             "        0B to base64\n"
             "        0Q to quoted printable\n"
             "        0X to quoted printable\n"
             "    [0-7]H to HTML coded text same char width\n"
             "    [0-7]D to HTML decimal codes\n"
             "    [0-7]X to HTML hexdecimal codes\n"
             "        B0 from base64\n"
             "        Q0 from quoted printable\n"
             "    Q[1-7] from hex to wide text\n"
             "    X[0-7] from HTML hexdecimal codes\n"
             "    D[0-7] from HTML decimal codes\n"
             "    H[0-7] from HTML code names\n"
           )
    ;
}

static void
/*****************************************************************************************************/
usagee() {                                                                                       /****
 *****************************************************************************************************/
    fprintf( stderr
           , "    0                 blin_ctl(BLIN_CTL_DUMP)\n"
             "    1                 babolo_optest(OptionsString)\n"
             "    2                 babolo_optext(OptionsDescriptor)\n"
             "    3                 babolo_dumpopts(OptionsDescriptor)\n"
             "    4[D]              inconsistent reverse, D - domain (1 TEXT, 2 G711)\n"
             "    5[D[Y[Z]]]        print table(s); D - domain, Y, Z code names\n"
             "    S[D[Y[Z]]]        write table(s); D - domain, Y, Z code names\n"
             "    6[A[B[name]]]     print norecoding table nameAB[]\n"
             "    7{u|A|Au|uA}      inconsistent G711u, G711A, A=>u, u=>a\n"
             "    8[D]              count, D - domain\n"
             "    9[Y[Z]]           test intermediators; Y, Z code names\n"
             "    Ck[w[a[i[m[z]]]]] create full recode tables from ETAT domain\n"
             "    E[Y[Z]]           compare with etalons\n"
             "    Rk[w[a[i[m[z]]]]] tests\n"
             "    OU                optimize unicodeuppertable\n"
             "    OD                optimize unicodelowertable\n"
             "    OUx               print not optimized unicodeuppertable\n"
             "    ODx               print not optimized unicodelowertable\n"
             "    OU[D]             create optimized unicodeuppertable\n"
             "    OD[D]             create optimized unicodelowertable\n"
             "    T                 BLIN trace\n"
             "    W                 make and print raw recobe_1k[65536]\n"
             "    WU                make and print raw recobe_ud[256]\n"
             "    WK                print recobe_1k[65536]\n"
             "    WN                substitute NO for \"\" and print recobe_1k[65536]\n"
             "    WX                print recobe_1k[65536] in hex\n"
           )
    ;
}

int
/*****************************************************************************************************
 *****************************************************************************************************/
main(int argc, char **argv) {                                                                    /****
 *****************************************************************************************************
 *****************************************************************************************************/
    const char       *flar   = "a:b:B:c:Ce:E:f:FHk:lLm:M:o:pPqs:t:Tv=:?:";
    recobe_opts      *opts   = NULL;
    int               ex     = EX_OK;
    int               c;

    if  (!(opts = calloc(1, sizeof(recobe_opts)))) {
        ifBLIN_QW0("No mem");
        ex = -EX_OSERR;
        goto out;
    }
    blin_ctl(BLIN_CTL_FLAG | BLIN_CTL_FSET, (opts->cf.flags = BLIN_BIT0));
#   define blin_internal_flags (opts->cf.flags)
    if  (!(opts->cf.bsubst = strdup("?"))) {
        ifBLIN_QW0("No mem");
        ex = -EX_OSERR;
        goto out;
    }
    if  (!(opts->bos = babolo_openopts(Bpars_ESYM | 'Y', 'Z'))) {
        ifBLIN_QW0("openopts");
        ex = -EX_SOFTWARE;
        goto out;
    }
    if  (!!babolo_setopts(opts->bos, Bpars_NONU, argc, argv, flar)) {
        ifBLIN_QW0("setopts");
        ex = -EX_SOFTWARE;
        goto out;
    }
    for (; !!(c = babolo_getopts(opts->bos));) {
        ifBLIN_QX4("%02X(%c)", c & 0x0FF, c);
        if  (0 > c) {
            ifBLIN_QW0("babolo_getopts");
            ex = -EX_USAGE;
            goto out;
        }
        switch (c) {
        case 'a': RECOBE_CASE_a;
                ; break;
        case 'b': RECOBE_CASE_b;
                ; break;
        case 'B': RECOBE_CASE_B;
                ; break;
        case 'c': RECOBE_CASE_c;
                ; break;
        case 'C': RECOBE_CASE_C;
                ; break;
        case 'e': RECOBE_CASE_e;
                ; break;
        case 'E': RECOBE_CASE_E;
                ; break;
        case 'f': RECOBE_CASE_f;
                ; break;
        case 'F': opts->cf.flags |= RECOBE_FULLCHECK;
                ; break;
        case 'H': RECOBE_CASE_H;
                ; break;
        case 'k': RECOBE_CASE_k;
                ; break;
        case 'l': opts->cf.flags |= RECOBE_PRELINERA;
                ; break;
        case 'L': RECOBE_CASE_L;
                ; break;
        case 'm': RECOBE_CASE_m;
                ; break;
        case 'M': RECOBE_CASE_M;
                ; break;
        case 'o': RECOBE_CASE_o;
                ; break;
        case 'p': opts->cf.flags |= RECOBE_PRINTABLE;
                ; break;
        case 'P': opts->cf.flags |= RECOBE_PRINTATLE;
                ; break;
        case 'q': BLIN_QUIET(opts->cf.flags);
                ; break;
        case 's': RECOBE_CASE_s;
                ; break;
        case 't': {   mife_descriptor *ifile = NULL;
                      ssize_t          insz;
                      u_char          *inin;
                      u_char           f   [2] = "0";
                      u_char           t   [2] = "0";
                      const char      *o   ;

                ;     o = babolo_getoptsarg(opts->bos);
                ;     f[0] = (u_char)o[0];
                ;     t[0] = (u_char)o[1];
                ;     if  (!(ifile = mife_init(MIFE_SLID))) {
                ;         ifBLIN_QW0("mife_init");
                ;         ex = -EX_IOERR;
                ;         goto out;
                ;     }
                ;     if  (!!opts->argin) {
                ;         if  (0 > mife_ctlbuff(ifile, opts->argin, strlen(opts->argin))) {
                ;             ifBLIN_QW0("mife_ctlbuff");
                ;             ex = -EX_IOERR;
                ;             goto out;
                ;         }
                ;     } else if (!!opts->filin) {
                ;         if  (0 > mife_ctlfile(ifile, !opts->filin ? "/dev/stdin" : opts->filin)) {
                ;             ifBLIN_QW0("mife_ctlfile");
                ;             ex = -EX_IOERR;
                ;             goto out;
                ;     }   }
                ;     if  (256 > (insz = mife_read(ifile, (ssize_t)256, (off_t)0))) {
                ;         ifBLIN_QW0("MIFE_CTLREAD");
                ;         ex = -EX_IOERR;
                ;         goto out;
                ;     }
                ;     if  (!(inin = mife_pointer(ifile))) {
                ;         ifBLIN_QW0("MIFE_POIWIND");
                ;         ex = -EX_IOERR;
                ;         goto out;
                ;     }
                ;     recobe_p256(f, t, RECOBE_TEXT, inin);
                ;     mife_fini(ifile);
                ; }
                ; break;
        case 'T': RECOBE_CASE_T;
                ; break;
        case 'v': BLIN_VERBOSE(opts->cf.flags);
                ; break;
        case '=': {   const u_char *Tflag;

                ;     if  (!(Tflag = (const u_char *)babolo_getoptsarg(opts->bos))) {
                ;         ifBLIN_QW0("babolo_getopts");
                ;         ex = -EX_USAGE;
                ;         goto out;
                ;     }
                ;     ifBLIN_QX4("%02X(%c)", *Tflag & 0x0FF, *Tflag);
                ;     switch(*Tflag) {
                ;     case '0': blin_ctl(BLIN_CTL_DUMP);    exit(EX_OK);
                ;     case '1': babolo_optest(flar);        exit(EX_OK);
                ;     case '2': babolo_optext(opts->bos);   exit(EX_OK);
                ;     case '3': babolo_dumpopts(opts->bos); exit(EX_OK);
                ;     case '4': exit(recobe_TestOrRevert(++Tflag));
                ;     case '5': exit(recobe_PrintAndMake(++Tflag));
                ;     case 'S': exit(recobe_WriteAndMake(++Tflag));
                ;     case '6': exit(recobe_PrintNoRecod(++Tflag));
                ;     case '7': exit(recobe_G711DiffConv(++Tflag));
                ;     case '8': exit(recobe_PrintFilling(++Tflag));
                ;     case '9': exit(recobe_InterMediaTo(++Tflag));
                ;     case 'E': exit(recobe_EtalonCompar(++Tflag));
                ;     case 'R': exit(recobe_ReCalculator(++Tflag));
                ;     case 'C': exit(recobe_ReCoordinate(++Tflag));
                ;     case 'W': exit(recobe_PrintWideStr(++Tflag));
                ;     case 'O': exit(recobe_TramplesDown(++Tflag));
                ;     case 'T': blin_ctl(BLIN_CTL_TCFN,++Tflag); break;
                ;     default : usage(); exit(EX_USAGE);
                ; }   }
                ; break;
        case '?': {   const char      *o;

                ;     if  (!(o = babolo_getoptsarg(opts->bos))) {
                ;         usage();
                ;         ex = -EX_OK;
                ;         goto out;
                ;     }
                ;     switch(*o) {
                ;     case '0': usage() ; ex = -EX_OK   ; break;
                ;     case 'c': usagec(); ex = -EX_OK   ; break;
                ;     case 's': usages(); ex = -EX_OK   ; break;
                ;     case 'k': usagek(); ex = -EX_OK   ; break;
                ;     case 'm': usagem(); ex = -EX_OK   ; break;
                ;     case '=': usagee(); ex = -EX_OK   ; break;
                ;     default : usage() ; ex = -EX_USAGE; break;
                ; }   }
                ; goto out;
        default : ifBLIN_QX0("Illegal flag -%c", opts->bos->c);
                ; usage();
                ; ex = -EX_USAGE;
                ; goto out;
    }   }
    if  (!opts->chain0) {
        ifBLIN_QX1("No recoding");
    } else {
        int         fdou = fileno(stdout);
        const char *o    = NULL;

        if  (!opts->filin && !opts->argin && !!(o = babolo_getargs(opts->bos))) {
            opts->filin = strdup(o);
        }
        ifBLIN_QX3( "fdou=%d fo%s%s~ argin%s%s~ filin%s%s~"
                  , fdou
                  , !o ? "" : "="
                  , !o ? "" : o
                  , !opts->argin ? "" : "="
                  , !opts->argin ? "" : opts->argin
                  , !opts->filin ? "" : "="
                  , !opts->filin ? "" : opts->filin
                  );
        if  (!!opts->argin) {
            recobe_chunk *out;

            if  (!(out = recobe_chainarr(opts->chain, strlen(opts->argin), opts->argin))) {
                ifBLIN_QW0("recobe_chainarr =%s~", opts->argin);
                ex = -EX_SOFTWARE;
                goto out;
            }
            if  (0 > mife_writ(fdou, recobe_chunktext(out), recobe_chunksize(out))) {
                ifBLIN_QW0("mife_writ");
                ex = -EX_IOERR;
                goto out;
            }
        } else {
            opts->chain0->next = recobe_openfile( &opts->cf
                                                , !opts->filin ? "/dev/stdin" : opts->filin
                                                , RECOBE_PREFLEN
                                                );
            recobe_chainput(opts->chain, fdou, mife_writ);
            mife_fini(opts->chain0->next->converdata);
            close(fdou);
        }
        free(opts->cf.mod);
        opts->cf.mod = NULL;
        recobe_close(opts->chain);
        opts->chain = NULL;
    }
out:
    free(opts->filin);
    babolo_closeopts(opts->bos);
    free(opts);
    exit((0 > ex) ? -ex : ex);
#   undef blin_internal_flags
}
