/*-
 * Copyright (C)2023..2024 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2023..2024 @BABOLO http://www.babolo.ru/"
#ident "@(#) $Id: unicodelower.c,v 1.4 2024/01/08 00:11:11 babolo Exp $"

#define BLIN_COMPAT     4
#define RECOBE_COMPAT   VMAJOR

#include <sys/types.h>
#include <stdio.h>
#include <babolo/BLINflag.h>
#include "recobe.h"

static const u_int16_t
/*********************************************************************************/
unicodelowertablerm[3456] =                                                  /****
 *********************************************************************************/
{  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0000 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0001 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0002 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0003 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0020, 0x0020, 0x0020,  0x0020, 0x0020, 0x0020, 0x0020 /* 0004 */
,  0x0020, 0x0020, 0x0020, 0x0020,  0x0020, 0x0020, 0x0020, 0x0020
,  0x0020, 0x0020, 0x0020, 0x0020,  0x0020, 0x0020, 0x0020, 0x0020 /* 0005 */
,  0x0020, 0x0020, 0x0020, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0006 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0007 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0020, 0x0020, 0x0020, 0x0020,  0x0020, 0x0020, 0x0020, 0x0020 /* 0008 */
,  0x0020, 0x0020, 0x0020, 0x0020,  0x0020, 0x0020, 0x0020, 0x0020
,  0x0020, 0x0020, 0x0020, 0x0020,  0x0020, 0x0020, 0x0020, 0x0000 /* 0009 */
,  0x0020, 0x0020, 0x0020, 0x0020,  0x0020, 0x0020, 0x0020, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 000A */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 000B */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000 /* 000C */
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000 /* 000D */
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000 /* 000E */
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000
,  0x0159, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000 /* 000F */
,  0x0000, 0x0003, 0x0000, 0x0007,  0x0000, 0x0003, 0x0000, 0x007F
,  0x0000, 0x0003, 0x0000, 0x0007,  0x0000, 0x0003, 0x0000, 0x000F /* 0010 */
,  0x0000, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000 /* 0011 */
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000 /* 0012 */
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000 /* 0013 */
,  0x0187, 0x0003, 0x0000, 0x0007,  0x0000, 0x0003, 0x0000, 0x0000
,  0x0000, 0x03D2, 0x0001, 0x0000,  0x0001, 0x0000, 0x03D2, 0x000F /* 0014 */
,  0x0000, 0x03DF, 0x03DD, 0x0007,  0x0000, 0x0000, 0x0053, 0x03D6
,  0x03CB, 0x0003, 0x0000, 0x03F3,  0x03F7, 0x0000, 0x03FF, 0x03FF /* 0015 */
,  0x0001, 0x0000, 0x0000, 0x0000,  0x03F3, 0x03EF, 0x0000, 0x03EA
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0326, 0x000F /* 0016 */
,  0x0000, 0x032A, 0x0000, 0x0000,  0x0001, 0x0000, 0x0326, 0x001F
,  0x0000, 0x033B, 0x0339, 0x0007,  0x0000, 0x0003, 0x0000, 0x0325 /* 0017 */
,  0x0001, 0x0000, 0x0000, 0x0000,  0x0001, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0002, 0x0003, 0x0000, 0x000E /* 0018 */
,  0x0001, 0x0000, 0x0006, 0x0007,  0x0000, 0x0003, 0x0000, 0x001F
,  0x0000, 0x0003, 0x0000, 0x0007,  0x0000, 0x0003, 0x0000, 0x000F /* 0019 */
,  0x0000, 0x0003, 0x0000, 0x0007,  0x0000, 0x0000, 0x0001, 0x0000
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000 /* 001A */
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000
,  0x0000, 0x0002, 0x0001, 0x0000,  0x0001, 0x0000, 0x0063, 0x0048 /* 001B */
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000 /* 001C */
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000 /* 001D */
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000
,  0x03BE, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000 /* 001E */
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 001F */
,  0x0000, 0x0000, 0x2E5F, 0x0007,  0x0000, 0x03A7, 0x2E58, 0x0000
,  0x0000, 0x0003, 0x0000, 0x03C3,  0x00CD, 0x00C9, 0x0001, 0x0000 /* 0020 */
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0021 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0022 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0023 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0024 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0025 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0026 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0000, 0x0000, 0x0001, 0x0000 /* 0027 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x008C
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x002A, 0x0000 /* 0028 */
,  0x0025, 0x0027, 0x0025, 0x0000,  0x0040, 0x0000, 0x0043, 0x0041
,  0x0000, 0x0020, 0x0020, 0x0020,  0x0020, 0x0020, 0x0020, 0x0020 /* 0029 */
,  0x0020, 0x0020, 0x0020, 0x0020,  0x0020, 0x0020, 0x0020, 0x0020
,  0x0060, 0x0060, 0x0000, 0x0060,  0x0060, 0x0060, 0x0060, 0x0060 /* 002A */
,  0x0060, 0x0060, 0x0060, 0x0060,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 002B */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 002C */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0018
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 002D */
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000 /* 002E */
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x004C, 0x0000, 0x0000, 0x000F /* 002F */
,  0x0000, 0x000B, 0x0001, 0x0000,  0x0000, 0x0086, 0x0082, 0x0082
,  0x0050, 0x0050, 0x0050, 0x0050,  0x0050, 0x0050, 0x0050, 0x0050 /* 0030 */
,  0x0050, 0x0050, 0x0050, 0x0050,  0x0050, 0x0050, 0x0050, 0x0050
,  0x0020, 0x0020, 0x0020, 0x0020,  0x0020, 0x0020, 0x0020, 0x0020 /* 0031 */
,  0x0020, 0x0020, 0x0020, 0x0020,  0x0020, 0x0020, 0x0020, 0x0020
,  0x0060, 0x0060, 0x0060, 0x0060,  0x0060, 0x0060, 0x0060, 0x0060 /* 0032 */
,  0x0060, 0x0060, 0x0060, 0x0060,  0x0060, 0x0060, 0x0060, 0x0060
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0033 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0034 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0035 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000 /* 0036 */
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000 /* 0037 */
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000
,  0x0001, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0038 */
,  0x0000, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000 /* 0039 */
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000 /* 003A */
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000 /* 003B */
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000
,  0x000F, 0x0003, 0x0000, 0x0007,  0x0000, 0x0003, 0x0000, 0x000F /* 003C */
,  0x0000, 0x0003, 0x0000, 0x0007,  0x0000, 0x0003, 0x0000, 0x0000
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000 /* 003D */
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000 /* 003E */
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000 /* 003F */
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000 /* 0040 */
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000 /* 0041 */
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000 /* 0042 */
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000
,  0x0000, 0x0050, 0x0050, 0x0050,  0x0050, 0x0050, 0x0050, 0x0050 /* 0043 */
,  0x0050, 0x0050, 0x0050, 0x0050,  0x0050, 0x0050, 0x0050, 0x0050
,  0x0030, 0x0030, 0x0030, 0x0030,  0x0030, 0x0030, 0x0030, 0x0030 /* 0044 */
,  0x0030, 0x0030, 0x0030, 0x0030,  0x0030, 0x0030, 0x0030, 0x0030
,  0x00D0, 0x00D0, 0x00D0, 0x00D0,  0x00D0, 0x00D0, 0x00D0, 0x0000 /* 0045 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0046 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0047 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0048 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0049 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x3DA0, 0x3DA0, 0x3DA0, 0x3DA0,  0x3DA0, 0x3DA0, 0x3DA0, 0x3DA0 /* 004A */
,  0x3DA0, 0x3DA0, 0x3DA0, 0x3DA0,  0x3DA0, 0x3DA0, 0x3DA0, 0x3DA0
,  0x3DA0, 0x3DA0, 0x3DA0, 0x3DA0,  0x3DA0, 0x3DA0, 0x3DA0, 0x3DA0 /* 004B */
,  0x3DA0, 0x3DA0, 0x3DA0, 0x3DA0,  0x3DA0, 0x3DA0, 0x3DA0, 0x3DA0
,  0x3DE0, 0x3DE0, 0x3DE0, 0x3DE0,  0x3DE0, 0x3DE0, 0x0000, 0x3DE0 /* 004C */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x3DE0, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 004D */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 004E */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 004F */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0050 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0051 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0xB8D0, 0xB8D0, 0xB8D0, 0xB8D0,  0xB8D0, 0xB8D0, 0xB8D0, 0xB8D0 /* 0052 */
,  0xB8D0, 0xB8D0, 0xB8D0, 0xB8D0,  0xB8D0, 0xB8D0, 0xB8D0, 0xB8D0
,  0xB830, 0xB830, 0xB830, 0xB830,  0xB830, 0xB830, 0xB830, 0xB830 /* 0053 */
,  0xB830, 0xB830, 0xB830, 0xB830,  0xB830, 0xB830, 0xB830, 0xB830
,  0xB850, 0xB850, 0xB850, 0xB850,  0xB850, 0xB850, 0xB850, 0xB850 /* 0054 */
,  0xB850, 0xB850, 0xB850, 0xB850,  0xB850, 0xB850, 0xB850, 0xB850
,  0xB870, 0xB870, 0xB870, 0xB870,  0xB870, 0xB870, 0xB870, 0xB870 /* 0055 */
,  0xB870, 0xB870, 0xB870, 0xB870,  0xB870, 0xB870, 0xB870, 0xB870
,  0xB850, 0xB850, 0xB850, 0xB850,  0xB850, 0xB850, 0xB850, 0xB850 /* 0056 */
,  0xB850, 0xB850, 0xB850, 0xB850,  0xB850, 0xB850, 0xB850, 0xB850
,  0x0008, 0x0008, 0x0008, 0x0008,  0x0008, 0x0008, 0x0000, 0x0000 /* 0057 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0058 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0C40, 0x0C40, 0x0C40, 0x0C40,  0x0C40, 0x0C40, 0x0C40, 0x0C40 /* 0059 */
,  0x0C40, 0x0C40, 0x0C40, 0x0C40,  0x0C40, 0x0C40, 0x0C40, 0x0C40
,  0x0C40, 0x0C40, 0x0C40, 0x0C40,  0x0C40, 0x0C40, 0x0C40, 0x0C40 /* 005A */
,  0x0C40, 0x0C40, 0x0C40, 0x0C40,  0x0C40, 0x0C40, 0x0C40, 0x0C40
,  0x0C40, 0x0C40, 0x0C40, 0x0C40,  0x0C40, 0x0C40, 0x0C40, 0x0C40 /* 005B */
,  0x0C40, 0x0C40, 0x0C40, 0x0000,  0x0000, 0x0C40, 0x0C40, 0x0C40
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000 /* 005C */
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000 /* 005D */
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000 /* 005E */
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000 /* 005F */
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000 /* 0060 */
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000 /* 0061 */
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000 /* 0062 */
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000 /* 0063 */
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000 /* 0064 */
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0000, 0x0000 /* 0065 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x1E41, 0x0000
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000 /* 0066 */
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000 /* 0067 */
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000 /* 0068 */
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000 /* 0069 */
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000 /* 006A */
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000 /* 006B */
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 006C */
,  0x0008, 0x0008, 0x0008, 0x0008,  0x0008, 0x0008, 0x0008, 0x0008
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 006D */
,  0x0008, 0x0008, 0x0008, 0x0008,  0x0008, 0x0008, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 006E */
,  0x0008, 0x0008, 0x0008, 0x0008,  0x0008, 0x0008, 0x0008, 0x0008
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 006F */
,  0x0008, 0x0008, 0x0008, 0x0008,  0x0008, 0x0008, 0x0008, 0x0008
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0070 */
,  0x0008, 0x0008, 0x0008, 0x0008,  0x0008, 0x0008, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0071 */
,  0x0000, 0x0008, 0x0000, 0x0008,  0x0000, 0x0008, 0x0000, 0x0008
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0072 */
,  0x0008, 0x0008, 0x0008, 0x0008,  0x0008, 0x0008, 0x0008, 0x0008
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0073 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0074 */
,  0x0008, 0x0008, 0x0008, 0x0008,  0x0008, 0x0008, 0x0008, 0x0008
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0075 */
,  0x0008, 0x0008, 0x0008, 0x0008,  0x0008, 0x0008, 0x0008, 0x0008
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0076 */
,  0x0008, 0x0008, 0x0008, 0x0008,  0x0008, 0x0008, 0x0008, 0x0008
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0077 */
,  0x0008, 0x0008, 0x00CA, 0x00CA,  0x000F, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0078 */
,  0x00BA, 0x00BA, 0x00BE, 0x00BE,  0x000F, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0079 */
,  0x0008, 0x0008, 0x00AC, 0x00AC,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 007A */
,  0x0008, 0x0008, 0x0090, 0x0090,  0x0009, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 007B */
,  0x0080, 0x0080, 0x0086, 0x0086,  0x000F, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 007C */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 007D */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x22EF, 0x0000 /* 007E */
,  0x0000, 0x0000, 0x2141, 0x21CE,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x007C, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 007F */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0080 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0081 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0010, 0x0010, 0x0010, 0x0010,  0x0010, 0x0010, 0x0010, 0x0010 /* 0082 */
,  0x0010, 0x0010, 0x0010, 0x0010,  0x0010, 0x0010, 0x0010, 0x0010
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0083 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0007,  0x0000, 0x0000, 0x0000, 0x0000 /* 0084 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0085 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0086 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0087 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0088 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0089 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 008A */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0066, 0x0066 /* 008B */
,  0x006A, 0x006A, 0x006E, 0x006E,  0x006A, 0x006A, 0x0066, 0x0066
,  0x001A, 0x001A, 0x001E, 0x001E,  0x001A, 0x001A, 0x0026, 0x0026 /* 008C */
,  0x002A, 0x002A, 0x002E, 0x002E,  0x002A, 0x002A, 0x0026, 0x0026
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 008D */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 008E */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 008F */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0030, 0x0030, 0x0030, 0x0030,  0x0030, 0x0030, 0x0030, 0x0030 /* 0090 */
,  0x0030, 0x0030, 0x0030, 0x0030,  0x0030, 0x0030, 0x0030, 0x0030
,  0x0050, 0x0050, 0x0050, 0x0050,  0x0050, 0x0050, 0x0050, 0x0050 /* 0091 */
,  0x0050, 0x0050, 0x0050, 0x0050,  0x0050, 0x0050, 0x0050, 0x0050
,  0x0070, 0x0070, 0x0070, 0x0070,  0x0070, 0x0070, 0x0070, 0x0070 /* 0092 */
,  0x0070, 0x0070, 0x0070, 0x0070,  0x0070, 0x0070, 0x0070, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0093 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0094 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0095 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0001, 0x0000, 0x2E09, 0x311E,  0x2E19, 0x0000, 0x0000, 0x000F /* 0096 */
,  0x0000, 0x0003, 0x0000, 0x0007,  0x0000, 0x2E3C, 0x2E1F, 0x2E3F
,  0x2E22, 0x0000, 0x0001, 0x0000,  0x0000, 0x0003, 0x0000, 0x0000 /* 0097 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x2E41, 0x2E3F
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000 /* 0098 */
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000 /* 0099 */
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000 /* 009A */
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000 /* 009B */
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000 /* 009C */
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000 /* 009D */
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 009E */
,  0x0000, 0x0000, 0x0000, 0x0007,  0x0000, 0x0003, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0001, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 009F */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000 /* 00A0 */
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000 /* 00A1 */
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000 /* 00A2 */
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 00A3 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000 /* 00A4 */
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000 /* 00A5 */
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 00A6 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 00A7 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 00A8 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 00A9 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000 /* 00AA */
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000
,  0x0000, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000 /* 00AB */
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000 /* 00AC */
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000 /* 00AD */
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000 /* 00AE */
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 00AF */
,  0x0000, 0x0003, 0x0000, 0x0007,  0x0000, 0xBA04, 0x0001, 0x0000
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000 /* 00B0 */
,  0x0000, 0x0000, 0x0000, 0x0007,  0x0000, 0xA5E8, 0x0000, 0x0000
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0000, 0x0000, 0x0001, 0x0000 /* 00B1 */
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000 /* 00B2 */
,  0x0001, 0x0000, 0xA5CC, 0xA5F7,  0xA5CD, 0xA5C1, 0xA5C4, 0x0000
,  0xA52E, 0xA536, 0xA52F, 0x0CE0,  0x0001, 0x0000, 0x0001, 0x0000 /* 00B3 */
,  0x0001, 0x0000, 0x0001, 0x0000,  0x0001, 0x0000, 0x0001, 0x0000
,  0x0000, 0x0000, 0x0001, 0x0000,  0x0050, 0xA547, 0xBA48, 0x000F /* 00B4 */
,  0x0000, 0x0003, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 00B5 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 00B6 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0003, 0x0000, 0x0000 /* 00B7 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 00B8 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 00B9 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0060, 0x0060, 0x0060,  0x0060, 0x0060, 0x0060, 0x0060 /* 00BA */
,  0x0060, 0x0060, 0x0060, 0x0060,  0x0060, 0x0060, 0x0060, 0x0060
,  0x0060, 0x0060, 0x0060, 0x0060,  0x0060, 0x0060, 0x0060, 0x0060 /* 00BB */
,  0x0060, 0x0060, 0x0060, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0028, 0x0028, 0x0028, 0x0028,  0x0028, 0x0028, 0x0028, 0x0028 /* 00BC */
,  0x0038, 0x0038, 0x0038, 0x0038,  0x0038, 0x0038, 0x0038, 0x0038
,  0x0028, 0x0028, 0x0028, 0x0028,  0x0028, 0x0028, 0x0028, 0x0028 /* 00BD */
,  0x0058, 0x0058, 0x0058, 0x0058,  0x0058, 0x0058, 0x0058, 0x0058
,  0x0068, 0x0068, 0x0068, 0x0068,  0x0068, 0x0068, 0x0068, 0x0068 /* 00BE */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 00BF */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 00C0 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 00C1 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 00C2 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0068, 0x0068, 0x0068, 0x0068,  0x0068, 0x0068, 0x0068, 0x0068 /* 00C3 */
,  0x0058, 0x0058, 0x0058, 0x0058,  0x0058, 0x0058, 0x0058, 0x0058
,  0x0028, 0x0028, 0x0028, 0x0028,  0x0028, 0x0028, 0x0028, 0x0028 /* 00C4 */
,  0x0038, 0x0038, 0x0038, 0x0038,  0x0038, 0x0038, 0x0038, 0x0038
,  0x0028, 0x0028, 0x0028, 0x0028,  0x0000, 0x0000, 0x0000, 0x0000 /* 00C5 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 00C6 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 00C7 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0040, 0x0040, 0x0040, 0x0040,  0x0040, 0x0040, 0x0040, 0x0040 /* 00C8 */
,  0x0040, 0x0040, 0x0040, 0x0040,  0x0040, 0x0040, 0x0040, 0x0040
,  0x0040, 0x0040, 0x0040, 0x0040,  0x0040, 0x0040, 0x0040, 0x0040 /* 00C9 */
,  0x0040, 0x0040, 0x0040, 0x0040,  0x0040, 0x0040, 0x0040, 0x0040
,  0x0040, 0x0040, 0x0040, 0x0040,  0x0040, 0x0040, 0x0040, 0x0040 /* 00CA */
,  0x0040, 0x0040, 0x0040, 0x0040,  0x0040, 0x0040, 0x0040, 0x0040
,  0x0040, 0x0040, 0x0040, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 00CB */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 00CC */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 00CD */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0060, 0x0060, 0x0060, 0x0060,  0x0060, 0x0060, 0x0060, 0x0060 /* 00CE */
,  0x0060, 0x0060, 0x0060, 0x0060,  0x0060, 0x0060, 0x0060, 0x0060
,  0x0060, 0x0060, 0x0060, 0x0060,  0x0060, 0x0060, 0x0060, 0x0060 /* 00CF */
,  0x0060, 0x0060, 0x0060, 0x0060,  0x0060, 0x0060, 0x0060, 0x0060
,  0x0020, 0x0020, 0x0020, 0x0020,  0x0020, 0x0020, 0x0020, 0x0020 /* 00D0 */
,  0x0020, 0x0020, 0x0020, 0x0020,  0x0020, 0x0020, 0x0020, 0x0020
,  0x0020, 0x0020, 0x0020, 0x0020,  0x0020, 0x0020, 0x0020, 0x0020 /* 00D1 */
,  0x0020, 0x0020, 0x0020, 0x0020,  0x0020, 0x0020, 0x0020, 0x0020
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 00D2 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 00D3 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0022, 0x0022, 0x0026, 0x0026,  0x0022, 0x0022, 0x002E, 0x002E /* 00D4 */
,  0x0022, 0x0022, 0x0026, 0x0026,  0x0022, 0x0022, 0x003E, 0x003E
,  0x0022, 0x0022, 0x0026, 0x0026,  0x0022, 0x0022, 0x002E, 0x002E /* 00D5 */
,  0x0022, 0x0022, 0x0026, 0x0026,  0x0022, 0x0022, 0x005E, 0x005E
,  0x0062, 0x0062, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 00D6 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 00D7 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
};

static const u_int16_t
/*********************************************************************************/
unicodelowertablerw[1957] =                                                  /****
 *********************************************************************************/
{  0x0000, 0x0001, 0x0000, 0x0002,  0x0003, 0x0004, 0x0005, 0x0006 /* 0000 00000 */
,  0x0007, 0x0008, 0x0000, 0x0000,  0x0000, 0x0009, 0x000A, 0x000B
,  0x000C, 0x000D, 0x000E, 0x000F,  0x0010, 0x0011, 0x0000, 0x0000 /* 0001 00400 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0002 00800 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0003 00C00 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0012, 0x0013,  0x0000, 0x0000, 0x0000, 0x0000 /* 0004 01000 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0014, 0x0015
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0005 01400 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0006 01800 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0016, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0007 01C00 */
,  0x0017, 0x0018, 0x0019, 0x001A,  0x001B, 0x001C, 0x001D, 0x001E
,  0x0000, 0x0000, 0x0000, 0x0000,  0x001F, 0x0020, 0x0021, 0x0000 /* 0008 02000 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0022, 0x0023,  0x0000, 0x0000, 0x0000, 0x0000 /* 0009 02400 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 000A 02800 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0024, 0x0025, 0x0026, 0x0027,  0x0000, 0x0000, 0x0000, 0x0000 /* 000B 02C00 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 000C 03000 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 000D 03400 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 000E 03800 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 000F 03C00 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0010 04000 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0011 04400 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0012 04800 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0013 04C00 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0014 05000 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0015 05400 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0016 05800 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0017 05C00 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0018 06000 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0019 06400 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 001A 06800 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 001B 06C00 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 001C 07000 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 001D 07400 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 001E 07800 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 001F 07C00 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0020 08000 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0021 08400 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0022 08800 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0023 08C00 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0024 09000 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0025 09400 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0026 09800 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0027 09C00 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0028 0A000 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0029 0A400 */
,  0x0000, 0x0028, 0x0029, 0x0000,  0x002A, 0x002B, 0x002C, 0x002D
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 002A 0A800 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 002B 0AC00 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 002C 0B000 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 002D 0B400 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 002E 0B800 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 002F 0BC00 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0030 0C000 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0031 0C400 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0032 0C800 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0033 0CC00 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0034 0D000 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0035 0D400 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0036 0D800 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0037 0DC00 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0038 0E000 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0039 0E400 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 003A 0E800 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 003B 0EC00 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 003C 0F000 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 003D 0F400 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 003E 0F800 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 003F 0FC00 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x002E, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0040 10000 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x002F, 0x0000, 0x0030, 0x0031,  0x0000, 0x0000, 0x0000, 0x0000 /* 0041 10400 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0042 10800 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0032, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0043 10C00 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0044 11000 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0045 11400 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0033, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0046 11800 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0047 11C00 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0048 12000 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0049 12400 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 004A 12800 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 004B 12C00 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 004C 13000 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 004D 13400 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 004E 13800 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 004F 13C00 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0050 14000 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0051 14400 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0052 14800 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0053 14C00 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0054 15000 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0055 15400 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0056 15800 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0057 15C00 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0058 16000 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0059 16400 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 005A 16800 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 005B 16C00 */
,  0x0000, 0x0034, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 005C 17000 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 005D 17400 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 005E 17800 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 005F 17C00 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0060 18000 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0061 18400 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0062 18800 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0063 18C00 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0064 19000 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0065 19400 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0066 19800 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0067 19C00 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0068 1A000 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0069 1A400 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 006A 1A800 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 006B 1AC00 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 006C 1B000 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 006D 1B400 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 006E 1B800 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 006F 1BC00 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0070 1C000 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0071 1C400 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0072 1C800 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0073 1CC00 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0074 1D000 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0075 1D400 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0076 1D800 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0077 1DC00 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0078 1E000 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000 /* 0079 1E400 */
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0000, 0x0000, 0x0000, 0x0000
,  0x0000, 0x0000, 0x0000, 0x0000,  0x0035};

u_int64_t
/*********************************************************************************
 *********************************************************************************/
recobe_unicodelower(u_int64_t d) {                                           /****
 *********************************************************************************
 *********************************************************************************/
    return( (0x1E940LU <= d)
          ? 0U
          : unicodelowertablerm[ (d & ((1 << 6) - 1))
                               + (u_int64_t)(unicodelowertablerw[d >> 6] << 6)
                               ]
          );
}
