/*-
 * Copyright (C)2018..2024 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2018..2024 @BABOLO http://www.babolo.ru/"
#ident "@(#) $Id: engine.c,v 1.49 2024/01/14 20:15:08 babolo Exp $"

#define MIFE_COMPAT     5
#define BLIN_COMPAT     4
#define RECOBE_COMPAT   VMAJOR
#define RECOBE_INTERNAL 1

#include <sys/types.h>
#include <sys/event.h>
#include <sys/time.h>
#include <sysexits.h>
#include <strings.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <babolo/BLINflag.h>
#include <mife.h>
#include "recobe.h"

static int
/*****************************************************************************************************
 ****                                                                          ****
 *****************************************************************************************************
                                                                                                  ****/
toer(recobe_chain *chain, recobe_chunk *chunk) {                                                 /****
                                                                                                  ****
 *****************************************************************************************************/
    int           ex = 1;

    for (int k = 0; !!chain->bsubst && !!chain->bsubst[k]; ++k) {
        if  (0 > (ex = recobe_outword(chain, chunk, (u_int64_t)chain->bsubst[k]))) goto out;
    }
    for (int k = 0; !!chain->esubst && !!chain->esubst[k]; ++k) {
        if  (0 > (ex = recobe_outword(chain, chunk, (u_int64_t)chain->esubst[k]))) goto out;
    }
out:
    if  (0 > ex) ex = 0;
    return(ex);
}

static recobe_chunk *
/*****************************************************************************************************
 ****                                                    ****
 *****************************************************************************************************
                                                                                                  ****/
convey(recobe_chain *chain) {                                                                    /****
                                                                                                  ****
 *****************************************************************************************************/
    recobe_chunk *newchunk = NULL;
    u_int32_t     tailen   = 0;
    recobe_chunk *source;
    u_int32_t     forer    = 0;
    int           ex       = EX_OK;
    int           l        = 0; /*DEBUG*/

    if  (!chain) {
        ifBLIN_QW0("No chain");
        errno = EFAULT;
        goto out;
    }
#   define blin_internal_flags (chain->flags)
    ifBLIN_QX3("+ chain=%"BLIN_X" f=%08X", BLIN_I(chain), chain->flags);
    for (recobe_chain *c = chain; !!c && (c != c->next); c = c->next) {   /*DEBUG*/
        ++l;                                                              /*DEBUG*/
        ifBLIN_QX4("%d %"BLIN_X" %"BLIN_X, l, BLIN_I(c), BLIN_I(c->next));/*DEBUG*/
    }                                                                     /*DEBUG*/
    if  ((chain->flags & RECOBE_TRACE)) {
        const recobe_c_tnm *encolist = recobe_collection.domains[chain->cnv.domain]->encolist;

        ifBLIN_QX0( ">>>%d %s=%c%c(%d: %c%d => %c%d) %ux%u=>%ux%u ~%s~%s~ ~%s~%s~" /*DEBUG*/
                  , l                                                              /*DEBUG*/
                  , recobe_collection.domains[chain->cnv.domain]->domname
                  , chain->cnv.nonesrc
                  ? '.'
                  : encolist[chain->cnv.encosrc].encoid ? encolist[chain->cnv.encosrc].encoid[0] : '-'
                  , chain->cnv.nonedst
                  ? '.'
                  : encolist[chain->cnv.encodst].encoid ? encolist[chain->cnv.encodst].encoid[0] : '-'
                  , chain->cnv.domain
                  , chain->cnv.nonesrc ? '-' : '+'
                  , chain->cnv.encosrc
                  , chain->cnv.nonedst ? '-' : '+'
                  , chain->cnv.encodst
                  , chain->inwlen
                  , chain->inwnum
                  , chain->outwlen
                  , chain->outwnum
                  , chain->bsubst ? chain->bsubst : ""
                  , chain->esubst ? chain->esubst : ""
                  , chain->bcode ? chain->bcode : ""
                  , chain->ecode ? chain->ecode : ""
                  );
        recobe_testtail(0, __FILE__, __func__, __LINE__, chain->tail);
    }
    RECOBE_CHAIN(chain);
    if  (chain->flags & RECOBE_CHAINER) {
        newchunk = chain->puller(chain);
        goto out;
    }
    for (                          /*          */
        ; ((u_int32_t)chain->inwlen * chain->inwnum) > (tailen = recobe_chunksize(chain->tail))
        ;
        ) {
        RECOBE_CHAIN(chain);
        if  (!!chain->next) {                                              /*    */
            if  (!(source = convey(chain->next))) {
                ifBLIN_QW0("convey");
                goto out;
            }
            RECOBE_CHUNK(newchunk);
            if  (0 > (ex = recobe_chunksum(chain, source))) {
                ifBLIN_QW0("recobe_chunksum");
                free(source);
                source = NULL;
                goto out;
            }
            free(source);
            source = NULL;
            if  (1 == ex) break;
            if  (2 == ex) {
                if  (chain->flags & RECOBE_DOEND) {
                    newchunk = recobe_chunknew(chain, chain->outwlen * chain->outwnum, 0, NULL);
                    if  (!newchunk) {
                        ifBLIN_QW0("recobe_chunknew %d", chain->outwlen * chain->outwnum);
                        goto out;
                    }
                    if  (0 > (ex = chain->convertor(chain, newchunk))) toer(chain, newchunk);
                    goto out;
                }
                if  (!(newchunk = recobe_chunknew(chain, 0, 0, NULL))) ifBLIN_QW0("recobe_chunknew");
                goto out;
            }
        } else if (!tailen) {                                        /*      */
            if  (!(newchunk = recobe_chunknew(chain, 0, 0, NULL))) ifBLIN_QW0("recobe_chunknew");
            goto out;
    }   }
    RECOBE_CHAIN(chain);
    tailen = recobe_chunksize(chain->tail);           /*        */
    ifBLIN_QX4("tailen=%u", tailen);
    if  (!chain->convertor) {
        ifBLIN_QX0("No convertor");
        free(newchunk);
        newchunk = NULL;
        errno = EFAULT;
        goto out;
    }
    /*       */
        tailen *= chain->outwlen * chain->outwnum / chain->inwlen + 1;
        if  (!!chain->bsubst) forer += strlen(chain->bsubst);
        if  (!!chain->esubst) forer += strlen(chain->esubst);
        forer *= chain->outwlen;
        if  (!!tailen && (tailen < forer)) tailen = forer;
        if  (!(newchunk = recobe_chunknew(chain, tailen, 0, NULL))) {
            ifBLIN_QW0("recobe_chunknew %d", tailen);
            goto out;
        }
        if  (!chain->tail) goto out;
        for (int e = 0; ;) {
            if  (0 > (e = chain->convertor(chain, newchunk))) toer(chain, newchunk);
            ifBLIN_QX4( "%d e=%d tailen=%u newpos=%u newlen=%u newsize=%u forer=%u" /*DEBUG*/
                        " out=%u size=%u len=%u pos=%u in=%u %d%d%d"
                      , l                                                           /*DEBUG*/
                      , e
                      , tailen
                      , newchunk->position
                      , newchunk->length
                      , newchunk->size
                      , forer
                      , chain->outwnum * chain->outwlen
                      , chain->tail->size
                      , chain->tail->length
                      , chain->tail->position
                      , chain->inwnum * chain->inwlen
                      , tailen < newchunk->length + forer
                      , tailen < newchunk->length + (chain->outwnum * chain->outwlen)
                      , chain->tail->length < chain->tail->position + (chain->inwnum * chain->inwlen)
                      );
            if  (  !e
                || !recobe_chunksize(chain->tail)
                || (tailen < newchunk->length + forer)
                || (tailen < newchunk->length + (chain->outwnum * chain->outwlen))
                || (chain->tail->length < chain->tail->position + (chain->inwnum * chain->inwlen))
                ) {
                break;
        }   }
out:
    if  ((chain->flags & RECOBE_TRACE)) {
        const recobe_c_tnm *encolist = recobe_collection.domains[chain->cnv.domain]->encolist;

        ifBLIN_QX0( "<<<%d %s=%c%c(%d: %c%d => %c%d)"
                  , ex
                  , recobe_collection.domains[chain->cnv.domain]->domname
                  , chain->cnv.nonesrc
                  ? '.'
                  : encolist[chain->cnv.encosrc].encoid ? encolist[chain->cnv.encosrc].encoid[0] : '-'
                  , chain->cnv.nonedst
                  ? '.'
                  : encolist[chain->cnv.encodst].encoid ? encolist[chain->cnv.encodst].encoid[0] : '-'
                  , chain->cnv.domain
                  , chain->cnv.nonesrc ? '-' : '+'
                  , chain->cnv.encosrc
                  , chain->cnv.nonedst ? '-' : '+'
                  , chain->cnv.encodst
                  );
        recobe_testtail(0, __FILE__, __func__, __LINE__, newchunk);
    }
    RECOBE_CHUNK(newchunk);
    ifBLIN_QX3("- %"BLIN_X, BLIN_I(newchunk));
    return(newchunk);
#   undef blin_internal_flags
}

int
/*****************************************************************************************************
 *****************************************************************************************************
 ****     chain  wrt                                     ****
 *****************************************************************************************************
                                                                                                  ****/
recobe_chainput(recobe_chain *chain, int fd, ssize_t (*wrt)(int fd, const void *buf, size_t size)) {
                                                                                                 /****
 *****************************************************************************************************
 *****************************************************************************************************/
    recobe_chunk *toout = NULL;
    int           ex = EX_OK;
    u_int32_t     length;
    ssize_t       wes;

    ifBLIN_QX3("+ chain=%"BLIN_X" to %d", BLIN_I(chain), fd);
    if  (!chain) {
        ifBLIN_QW0("No chain");
        ex = EX_NOINPUT;
        errno = EFAULT;
        goto out;
    }
#   define blin_internal_flags (chain->flags)
    RECOBE_CHAIN(chain);
    for (int i = 0;; ++i) {
        if  (!(toout = convey(chain))) {
            recobe_cnverr(__FILE__, __func__, __LINE__, "convey", chain->cnv);
            ex = EX_SOFTWARE;
            goto out;
        }
        length = recobe_chunksize(toout);
        wes = wrt(fd, recobe_chunktext(toout), length);
        if  (RECOBE_EOT == toout->position) {
            free(toout);
            toout = NULL;
            break;
        }
        free(toout);
        toout = NULL;
        if  (0 > wes) {
            ifBLIN_QW0("mife_writ");
            ex = EX_IOERR;
            goto out;
        }
        if  ((ssize_t)length != wes) {
            ifBLIN_QW0("mife_writ(,,%d) <> %d", (int)length, (int)wes);
            ex = EX_IOERR;
            goto out;
    }   }
out:
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

recobe_chunk *
/*****************************************************************************************************
 *****************************************************************************************************
 ****     chain                                   ****
 *****************************************************************************************************
                                                                                                  ****/
recobe_chainbuf(recobe_chain *chain) {                                                           /****
                                                                                                  ****
 *****************************************************************************************************
 *****************************************************************************************************/
    recobe_chunk *toout = NULL;
    recobe_chunk *tail  = NULL;
    recobe_chunk *sum   = NULL;

    ifBLIN_QX3("+ chain=%"BLIN_X, BLIN_I(chain));
    if  (!chain) {
        ifBLIN_QW0("No chain");
        errno = EFAULT;
        goto out;
    }
#   define blin_internal_flags (chain->flags)
    RECOBE_CHAIN(chain);
    for (int i = 0; ; ++i) {
        if  (!(toout = convey(chain))) {
            recobe_cnverr(__FILE__, __func__, __LINE__, "convey", chain->cnv);
        }
        RECOBE_CHAIN(chain);
        if  (!recobe_chunksize(toout)) {
            ifBLIN_QX3("size 0");
            if  (chain->flags & RECOBE_DOEND) continue;
            free(toout);
            break;
        }
        if  (!(sum = recobe_chunkat(chain, tail, toout))) {
            recobe_cnverr(__FILE__, __func__, __LINE__, "chunkat", chain->cnv);
        }
        free(tail);
        free(toout);
        tail = sum;
        sum = NULL;
        RECOBE_CHUNK(tail);
        if  (!tail) break;
    }
out:
    ifBLIN_QX3("+ tail=%"BLIN_X, BLIN_I(tail));
    return(tail);
#   undef blin_internal_flags
}
