#!/usr/local/bin/pgoblin -f
  Copyright (C)2021..2022 @BABOLO http://www.babolo.ru/
  PKG = mini-cipa-dripa
  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:
  1. Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.

  THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
  OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
  OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
  SUCH DAMAGE.

  $Id: minicipa.pgoblin.m4,v 1.41 2022/06/13 13:37:21 babolo Exp $

#connect 0001
CIPA_DBMS
GETARG(, 1, 1)
GETENV(, 1, 1)
#perform 0001
CREATE TEMP TABLE x(b text, u text);
#perform 0001
INSERT INTO x
 SELECT COALESCE( (SELECT a FROM a WHERE i = 0 AND regexp('^[a-z0-9_]+$', a))
                , 'minicipa'
                )
      , (SELECT e FROM e WHERE n = 'USER' AND regexp('^[a-z0-9_]+$', e))
;
#select  1001
SELECT 'pgsql dbname=' || x.b || ' requirepeer=postgres application_name=minicipa'
 FROM x
;
#connect 0102
#select  u001  #######################################  u - ${USER}, b - ${PROTOVER}  minicipa  ####
SELECT u FROM x;
#select  b001
SELECT b FROM x;
#select  10u2  ##########################################  CREATE ROLE ${USER} WITH LOGIN INHERIT  ####
SELECT 'CREATE ROLE ' || r.r || ' WITH LOGIN INHERIT;
'FROM  (SELECT $1::text AS r)r
  LEFT JOIN pg_catalog.pg_roles ON(r.r = pg_roles.rolname::text)
 WHERE pg_roles.rolname IS NULL
;
#perform 0102
#select  1002  ############################################  CREATE ROLE www WITH LOGIN NOINHERIT  ####
SELECT 'CREATE ROLE ' || r.r || ' WITH LOGIN NOINHERIT;
'FROM  (SELECT 'www'::text AS r)r
  LEFT JOIN pg_catalog.pg_roles ON(r.r = pg_roles.rolname::text)
 WHERE pg_roles.rolname IS NULL
;
#perform 0102
#select  1001  #####################  GRANT CONNECT, TEMP ON DATABASE ${PROTOVER} TO ${USER}, www  ####
 SELECT 'GRANT CONNECT, TEMP ON DATABASE ' || x.b || ' TO ' || x.u || ', www;
' FROM x
;
#perform 0102
#select  1001  ##################################  GRANT TEMP ON DATABASE ${PROTOVER} TO operator  ####
 SELECT 'GRANT TEMP ON DATABASE ' || x.b || ' TO operator;
' FROM x
;
#perform 0102
#perform 0002
CREATE EXTENSION IF NOT EXISTS babolo_pglib;
#perform 0002
CREATE EXTENSION IF NOT EXISTS pgcrypto;
#!#####################################################################################################
#perform 0002  ############################################################################  gate  ####
CREATE SEQUENCE IF NOT EXISTS public.gate_q MINVALUE 0;
#perform 0002
CREATE TABLE IF NOT EXISTS public.gate
     ( credent integer   PRIMARY KEY DEFAULT nextval('public.gate_q')
     , login   text      NOT NULL
     , src     cidr      NOT NULL
     , pass    text
     , entitle varbit
     , remark  text
     )
;
TRIGGERSETON(gatesync, public.gate, 2)
#perform 0002
CREATE UNIQUE INDEX IF NOT EXISTS gate_u ON public.gate(login, pass, src);
#perform 0002
SELECT setval('public.gate_q', MAX(gate.credent)) FROM public.gate;
#perform 0002
COMMENT ON TABLE public.gate         IS '';
COMMENT ON COLUMN public.gate.credent   IS '  ';
COMMENT ON COLUMN public.gate.login     IS '';
COMMENT ON COLUMN public.gate.src       IS 'IP ,    ';
COMMENT ON COLUMN public.gate.pass      IS '';
COMMENT ON COLUMN public.gate.entitle   IS '';
COMMENT ON COLUMN public.gate.remark    IS '';
#perform 0002  ####################################################################   sync  ####
CREATE TABLE IF NOT EXISTS public.sync
     ( m       text
     , v       text
     , PRIMARY KEY(m, v)
     )
;
#perform 0002
COMMENT ON TABLE public.sync           IS ' sync   tolate()';
COMMENT ON COLUMN public.sync.m           IS '  - ';
COMMENT ON COLUMN public.sync.v           IS '    ';
#perform 0002  ######################################################################  session(b)  ####
CREATE SEQUENCE IF NOT EXISTS public.session_q MINVALUE 0;
#perform 0002
CREATE TABLE IF NOT EXISTS public.session
     ( session integer   PRIMARY KEY DEFAULT nextval('public.session_q')
     , credent integer   REFERENCES public.gate
     , csrc    inet      NOT NULL
     , creat   timestamp NOT NULL DEFAULT now()
     , updat   timestamp NOT NULL DEFAULT now()
     )
;
#perform 0002
COMMENT ON TABLE public.session         IS '';
COMMENT ON COLUMN public.session.session   IS '    ';
COMMENT ON COLUMN public.session.credent   IS '  ';
COMMENT ON COLUMN public.session.csrc      IS 'IP  ';
COMMENT ON COLUMN public.session.creat     IS '  ';
COMMENT ON COLUMN public.session.updat     IS '  ';
#perform 0002
CREATE TABLE IF NOT EXISTS public.sessionb
     ( remov   timestamp NOT NULL DEFAULT now()
     ) INHERITS (public.session)
;
#perform 0002
COMMENT ON TABLE public.sessionb         IS ' ';
COMMENT ON COLUMN public.sessionb.session   IS '    ';
COMMENT ON COLUMN public.sessionb.credent   IS '  ';
COMMENT ON COLUMN public.sessionb.csrc      IS 'IP  ';
COMMENT ON COLUMN public.sessionb.creat     IS '  ';
COMMENT ON COLUMN public.sessionb.updat     IS '  ';
COMMENT ON COLUMN public.sessionb.remov     IS '  ';
#perform 0002
SELECT setval('public.session_q', MAX(session.session)) FROM public.session;
#perform 0002
CREATE OR REPLACE RULE sessionr AS
 ON DELETE TO public.session
 DO ALSO
  INSERT INTO public.sessionb(session, credent, csrc, creat, updat) SELECT OLD.*
;
#perform 0002  ########################################################################  cipaconf  ####
CREATE TABLE IF NOT EXISTS public.cipaconf
     ( a1   int8
     , a2   int8
     , a3   int8
     , ln   interval
     )
;
#perform 0002
COMMENT ON TABLE public.cipaconf      IS '    HTTP';
COMMENT ON COLUMN public.cipaconf.a1     IS ' ';
COMMENT ON COLUMN public.cipaconf.a2     IS ' ';
COMMENT ON COLUMN public.cipaconf.a3     IS ' ';
COMMENT ON COLUMN public.cipaconf.ln     IS '   ';
#perform 0002 -- 18446744073709551615, 18446744073709501313, 14445763322349571339
INSERT INTO public.cipaconf
 SELECT 1073741825, 1073741101, 955835743, '30m'
  WHERE NOT EXISTS(SELECT 1 FROM public.cipaconf)
;
#perform 0002  ##################################################    resess(int8)  ####
CREATE OR REPLACE FUNCTION public.resess(sess int8)
 RETURNS int8
 AS 'SELECT ((sess * cipaconf.a3) + cipaconf.a2) % cipaconf.a1 FROM public.cipaconf'
 LANGUAGE 'sql'
 STABLE
 STRICT
 PARALLEL SAFE
;
#perform 0002  ##########################################################################  logoff  ####
CREATE TABLE IF NOT EXISTS public.logoff
     ( login   text      NOT NULL
     , src     inet      NOT NULL
     , pass    text      NOT NULL
     , dt      timestamp NOT NULL DEFAULT now()
     )
;
#perform 0002
COMMENT ON TABLE public.logoff        IS ' ';
COMMENT ON COLUMN public.logoff.login    IS '';
COMMENT ON COLUMN public.logoff.src      IS '  IP';
COMMENT ON COLUMN public.logoff.pass     IS ' ';
COMMENT ON COLUMN public.logoff.dt       IS ' ';
#perform 0002
CREATE INDEX IF NOT EXISTS logoff_dt ON public.logoff(src, dt, login);
#!#####################################################################################################
#begin   0002
#perform 0002  ################################################################  cipaown postgres  ####
INSERT INTO public.cipaown(owname, ownpath)
 SELECT 'postgres', ARRAY['/usr/local/bin/su2', 'postgres', '--']
ON CONFLICT DO NOTHING
;
#select  1002  ######################################################  cipa mini-cipa-dripa clear  ####
INSERT INTO public.cipalan(cipath, selflock, cipaown, selfgr, success, resource)
 SELECT ARRAY['/usr/local/bin/cipa', 'PKG', 'clear', 'PROTOVER']
      , 3
      , (SELECT cipaown FROM public.cipaown WHERE owname = 'postgres')
      , TRUE
      , FALSE
      , '\x0000000001'
  WHERE NOT EXISTS(SELECT
                    FROM public.cipalan
                    WHERE cipath = ARRAY['/usr/local/bin/cipa', 'PKG', 'clear', 'PROTOVER']
                      AND period IS NULL
                  )
RETURNING cipalan
;
#perform 0012
INSERT INTO public.cipapan SELECT 'PKG', 'clear', $1 ON CONFLICT DO NOTHING;
#select  1002  ###############################################  cipa mini-cipa-dripa clear @54min  ####
INSERT INTO public.cipalan(cipath, selflock, cipaown, period, selfgr, success, resource)
 SELECT ARRAY['/usr/local/bin/cipa', 'PKG', 'clear', 'PROTOVER']
      , 3
      , (SELECT cipaown FROM public.cipaown WHERE owname = 'postgres')
      , '54min'
      , TRUE
      , FALSE
      , '\x0000000001'
  WHERE NOT EXISTS(SELECT
                    FROM public.cipalan
                    WHERE cipath = ARRAY['/usr/local/bin/cipa', 'PKG', 'clear']
                      AND period IS NOT NULL
                  )
RETURNING cipalan
;
#perform 0012
INSERT INTO public.cipago(cipalan, ciparg)
 SELECT $1, ARRAY['PROTOVER']
  WHERE NOT EXISTS(SELECT FROM public.cipain WHERE (cipalan, ciparg) = ($1, ARRAY['PROTOVER']))
;
#select  1002  #######################################################  cipa mini-cipa-dripa sync  ####
INSERT INTO public.cipalan(cipath, selflock, cipaown, selfgr, success, resource)
 SELECT ARRAY['/usr/local/bin/cipa', 'PKG', 'sync', 'PROTOVER']
      , 3
      , (SELECT cipaown FROM public.cipaown WHERE owname = 'postgres')
      , TRUE
      , TRUE
      , '\x0000000004'
  WHERE NOT EXISTS(SELECT
                    FROM public.cipalan
                    WHERE cipath = ARRAY['/usr/local/bin/cipa', 'PKG', 'sync', 'PROTOVER']
                      AND period IS NULL
                  )
RETURNING cipalan
;
#perform 0012
INSERT INTO public.cipapan SELECT 'PKG', 'sync', $1 ON CONFLICT DO NOTHING;
#end     0002
#!#####################################################################################################
#select  10b2
SELECT '
 GRANT SELECT
  ON public.gate
   , public.sync
   , public.gate_q
   , public.session
   , public.session_q
   , public.sessionb
   , public.cipaconf
   , public.cipares_q
   , public.cipares
   , public.ciparam
   , public.cipamask
   , public.cipalevel_q
   , public.cipadecod
  TO ' || quote_ident($1::text) || ', operator, www
;
'
;
#perform 0102
#perform 0002
GRANT INSERT ON public.session TO www;
#perform 0002
GRANT UPDATE ON public.session, public.session_q TO www;
#perform 0002
GRANT SELECT ON public.logoff TO operator;
#perform 0002
GRANT INSERT ON public.logoff TO www;
#perform 0002
GRANT SELECT, UPDATE ON public.cipaup, public.cipago TO www;
#perform 0002
GRANT SELECT ON public.cipaghost, public.cipacome, public.cipacut, public.cipalan TO www;
#select  10b2
SELECT '
 GRANT SELECT, INSERT
  ON public.cipago, public.cipaut, public.cipadecod
  TO ' || quote_ident($1::text) || ', operator, www
;
'
;
#perform 0102
#perform 0002
GRANT USAGE ON SEQUENCE public.cipaxn_q TO www;
#perform 0002
builtin(ifelse, PROTOVER, , SELECT public.cipaover('PKG', NULL, MAJOR, 'MINOR');
, SELECT public.cipaover('PKG', 'PROTOVER', MAJOR, 'MINOR');
)dnl
#exit
#   ,     
#perform 0002
CREATE TABLE IF NOT EXISTS public.xlogge
     ( i int
     , n text
     , p text
     , l text
     , s text
     , a text
     , b text
     , t timestamp DEFAULT now()
     )
;
#perform 0002
GRANT INSERT ON public.xlogge TO www;
#
