#
# Copyright (C)2019 @BABOLO http://www.babolo.ru/
# PKG = mini-cipa-dripa
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#
# $Id: pass.pleaf.m4,v 1.9 2020/05/27 00:57:14 babolo Exp $

eval
#echo    Q
##Q copy E
#style   00Q00Q
Q
GETPOST(,1)
#close   101
#select  1001
SELECT 'pgsql dbname=' || cipa || ' requirepeer=postgres' FROM x;
#connect 0102
#perform 0002
CREATE TEMP TABLE x
     ( login     text
     , pass      text
     , version   text
     , page      int
     , src       inet
     , host      text
     , scheme    text
     , https     text
     , refer     text
     , me        text
     , credent   int      -- 
     , session   int
     )
;

#select  1001
SELECT (SELECT p.p FROM p WHERE p.n = 'login'    AND p.i = 0 AND regexp('^[-0-9a-zA-Z_.]+$', p.p))
     , (SELECT p.p FROM p WHERE p.n = 'password' AND p.i = 1)
     , (SELECT p.p FROM p WHERE p.n = 'version'  AND p.i = 2 AND regexp('^[0-9]+\.[0-9]+$', p.p))
     , (SELECT p.p FROM p WHERE                      p.i = 2 AND regexp('^[0-9]+$', p.p))
     , (SELECT e.e FROM e WHERE e.n = 'REMOTE_ADDR'  AND regexp('^([0-9]{1,3}\.){3}[0-9]{1,3}$', e.e))
     , (SELECT e.e FROM e WHERE e.n = 'HTTP_HOST'     AND regexp('^[-a-zA-Z0-9_.:]+$', e.e))
     , (SELECT e.e FROM e WHERE e.n = 'REQUEST_SCHEME' AND regexp('^[-a-zA-Z0-9_]+$', e.e))
     , (SELECT e.e FROM e WHERE e.n = 'HTTPS'          AND 'on' = e.e)
     , (SELECT e.e FROM e WHERE e.n = 'HTTP_REFERER'  AND regexp('^http', e.e))
;
#perform 0012
INSERT INTO x(login, pass, version, page, src, host, scheme, https, refer)
 VALUES($1::text, $2::text, $3::text, $4::int, $5::inet, $6::text, $7::text, $8::text, $9::text)
;
#select  I001
SELECT i, n, p FROM p;
#trap
#return
#perform 00I2
INSERT INTO public.xlogge(i, n, p, l, s, a, b)
 SELECT $1, $2, $3, login, pass, src, host
  FROM x
;
#untrap
#perform 0002
UPDATE x SET scheme = 'https' WHERE refer ~ '^https://';
#perform 0002
UPDATE x SET scheme = 'http' WHERE refer ~ '^http://';
#perform 0002
UPDATE x SET me = host WHERE host ~ '^https?://';
#perform 0002
UPDATE x SET me = scheme || '://' || host WHERE me IS NULL;
#perform 0002
UPDATE x
   SET me = CASE WHEN https = 'on' THEN 'https' ELSE 'http' END || '://' || host
 WHERE me IS NULL
;
#perform 0002
UPDATE x SET credent = gate.credent
 FROM public.gate
 WHERE (gate.login, gate.pass) = (x.login, x.pass)
   AND gate.src >>= x.src
;
#perform 0002
WITH z AS (INSERT INTO public.session(credent, csrc)
            SELECT credent, src FROM x WHERE credent IS NOT NULL
           RETURNING session
          )
UPDATE x SET session = z.session FROM z
;
#
