#!BINDIR/pgoblin -f
  Copyright (C)2019..2024 @BABOLO http://www.babolo.ru/
--pkg = PKG
  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:
  1. Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.

  THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
  OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
  OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
  SUCH DAMAGE.

  $Id: minicipa.pgoblin.m4,v 1.101 2024/09/29 14:42:14 babolo Exp $

 set.pgoblin 
    P1 v.v   .
    P1Pqb ${PROTOVER}
    P1Pqu ${USER}
    P2  

#connect 0001
CIPADBMS
GETARG(, 1, 1)
GETENV(, 1, 1)
#echo    Q
##Q copy E
#style   00Q00Q
Q
#cat     U  ################@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@    - , ,   set  @@@@
set.pgoblin
#eval    0U
#close   U0U
#perform 0002  ############################################################################  fake  ####
CREATE TABLE IF NOT EXISTS public.fake(fake bool);
#perform 0002
INSERT INTO public.fake(fake) VALUES(NULL);
#perform 0002
CREATE OR REPLACE RULE fakei AS
    ON INSERT TO public.fake
    DO INSTEAD NOTHING
;
#perform 0002
CREATE OR REPLACE RULE faked AS
    ON DELETE TO public.fake
    DO INSTEAD NOTHING
;
#perform 0002
GRANT ALL ON public.fake TO public;
#cat     U  ################@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@    journal  @@@@
journal.pgoblin
#eval    0U
#close   U0U
#cat     U  ################@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@    dossier  @@@@
dossier.pgoblin
#eval    0U
#close   U0U
#echo    U  ####################################################      ####
##select  1002                                                                                        #
SELECT '
###perform 0002                                                                                       #
 INSERT INTO public.cipaown(owname, ownpath)
  SELECT DISTINCT whom, ARRAY[''/usr/local/bin/su2'', whom, ''--'']
   FROM public.cipalan
 ON CONFLICT DO NOTHING
;
###perform 0002                                                                                       #
CREATE TEMP TABLE pcl AS
 SELECT cipalan, cipath, selflock, cipaown, period, strict, selfgr, success, resource, resar, renul
  FROM public.cipalan JOIN public.cipaown ON(whom = owname)
;
'FROM information_schema.columns
    , information_schema.information_schema_catalog_name
 WHERE (table_catalog, table_schema, table_name, column_name)
     = (catalog_name, 'public', 'cipalan', 'whom')
;
##eval    01                                                                                          #
##select  1002                                                                                        #
SELECT '
CREATE TEMP TABLE pcl AS
 SELECT cipalan, cipath, selflock, cipaown, period, strict, selfgr, success, resource, resar, renul
  FROM public.cipalan
;
'FROM information_schema.columns
    , information_schema.information_schema_catalog_name
 WHERE (table_catalog, table_schema, table_name, column_name)
     = (catalog_name, 'public', 'cipalan', 'cipaown')
;
##perform 0102                                                                                        #
##perform 0002                                                                                        #
CREATE TABLE IF NOT EXISTS public.cipain
     ( cipain  int8
     , cipaher int8
     , cipalan int
     , waitout int8[]
     , ciparg  text[]
     , plan    timestamp
     , prio    int
     , deed    timestamp
     , pid     int
     , try     int
     , ghost   bool
     )
;
##perform 0002                                                                                        #
CREATE TEMP TABLE pcu AS
 SELECT cipain, unnest(waitout) AS cipaut
  FROM public.cipain
;
##perform 0002                                                                                        #
CREATE TEMP TABLE pci AS
 SELECT cipain, cipaher, cipalan, waitout, ciparg, plan, prio, try, ghost
  FROM public.cipain
;
##select  1002                                                                                        #
SELECT '
DROP TABLE IF EXISTS public.cipain CASCADE;
;
'FROM information_schema.tables
    , information_schema.information_schema_catalog_name
 WHERE (table_catalog, table_schema, table_name, table_type)
     = (catalog_name, 'public', 'cipain', 'BASE TABLE')
;
##perform 0102                                                                                        #
##perform 0002                                                                                        #
CREATE TABLE IF NOT EXISTS public.cipaon
     ( cipaon    int8
     , cipalan   int4
     , ciparg    text[]
     , plan      timestamptz
     , deed      timestamptz
     , pid       int4
     , reed      timestamptz
     , try       int4
     )
;
##perform 0002                                                                                        #
CREATE TEMP TABLE pco AS
 SELECT cipaon, cipalan, ciparg, plan, deed, pid, reed, try
  FROM public.cipaon
;
##perform 0002                                                                                        #
DROP RULE IF EXISTS cipauto ON public.cipato;
##perform 0002                                                                                        #
DROP RULE IF EXISTS cipagup ON public.cipaup;
##perform 0002                                                                                        #
DROP VIEW IF EXISTS public.cipaup;
##perform 0002                                                                                        #
DROP FUNCTION IF EXISTS public.cipatree(int8, int8[], text[], timestamp, int2);
##perform 0002                                                                                        #
DROP FUNCTION IF EXISTS public.cipatree(int8, int8[], text[], timestamp, int4);
##perform 0002                                                                                        #
DROP FUNCTION IF EXISTS public.cipatree(int8);
##perform 0002                                                                                        #
DROP RULE IF EXISTS cipaun ON public.cipaxn;
##perform 0002                                                                                        #
DROP RULE IF EXISTS cipain ON public.cipaxn;
##perform 0002                                                                                        #
DROP RULE IF EXISTS cipadn ON public.cipaxn;
##perform 0002                                                                                        #
DROP VIEW IF EXISTS public.cipaxn;
##perform 0002                                                                                        #
DROP VIEW IF EXISTS public.cipaxn20;
##perform 0002                                                                                        #
DROP VIEW IF EXISTS public.cipaxn21;
##perform 0002                                                                                        #
DROP TABLE IF EXISTS public.cipago CASCADE;
##perform 0002                                                                                        #
DROP TABLE IF EXISTS public.cipaon CASCADE;
##perform 0002                                                                                        #
DROP TABLE IF EXISTS public.cipalan CASCADE;
##perform 0002                                                                                        #
DROP TABLE IF EXISTS public.cipacome CASCADE;
##perform 0002                                                                                        #
DROP FUNCTION IF EXISTS public.cipaun(cipain int8) CASCADE;
#!  ############################################################      ####
#perform 0002
CREATE TEMP TABLE IF NOT EXISTS pcl
     ( cipalan  int
     , cipath   text[]
     , selflock int
     , cipaown  int
     , period   interval
     , strict   bool
     , selfgr   bool
     , success  bool
     , resource bytea
     , resar    int[]
     , renul    text[]
     )
;
#echo    V  ###############################################################     ####
##perform 0002                                                                                        #
INSERT INTO public.cipalan
       (cipalan, cipath, selflock, cipaown, period, strict, selfgr, success, resource, resar, renul)
 SELECT cipalan, cipath, selflock, cipaown, period, strict, selfgr, success, resource, resar, renul
  FROM pcl
;
##perform 0002                                                                                        #
INSERT INTO public.cipaon(cipaon, cipalan, ciparg, plan, deed, pid, reed, try)
 SELECT cipaon, cipalan, ciparg, plan, deed, pid, reed, try
  FROM pco
;
##perform 0002                                                                                        #
INSERT INTO public.cipacome(cipain, cipalan, ciparg, splan, prii)
 SELECT cipain, cipalan, ciparg, '0'::interval, make_interval(0, 0, 0, 0, 0, 0, prio)
  FROM pci
  WHERE ghost
;
##perform 0002                                                                                        #
INSERT INTO public.cipago(cipain, cipaher, cipalan, ciparg, plan, prii, try)
 SELECT cipain, cipaher, cipalan, ciparg, plan, make_interval(0, 0, 0, 0, 0, 0, prio), try
  FROM pci
  WHERE NOT ghost
;
##perform 0002                                                                                        #
DELETE FROM public.cipaut;
##perform 0002                                                                                        #
INSERT INTO public.cipaut(cipain, cipaut)
 SELECT cipain, cipaut
  FROM pcu
  WHERE cipain IN(SELECT cipain FROM public.cipago)
    AND cipaut IN(SELECT cipain FROM public.cipago)
;
##perform 0002                                                                                        #
DELETE FROM public.cipacut;
##perform 0002                                                                                        #
INSERT INTO public.cipacut(cipain, cipaut)
 SELECT cipain, cipaut
  FROM pcu
  WHERE cipain IN(SELECT cipain FROM public.cipacome)
    AND cipaut IN(SELECT cipain FROM public.cipacome)
;
#!  ############################################################      ####
    @@@@@@@@@@@@@@@@@@@@@@@@========================================================    ====
#perform 0002  ###################################################    cipaown  ####
CREATE SEQUENCE IF NOT EXISTS public.cipaown_q MINVALUE 0;
#perform 0002
CREATE TABLE IF NOT EXISTS public.cipaown
     ( cipaown   int4      PRIMARY KEY DEFAULT nextval('public.cipaown_q')
     , owname    text      NOT NULL UNIQUE
     , ownpath   text[]    NOT NULL
     )
;
#perform 0002
SELECT setval('public.cipaown_q', COALESCE(MAX(cipaown.cipaown) + 1, 0), FALSE) FROM public.cipaown;
#perform 0002  ###########################################################################    ####
CREATE SEQUENCE IF NOT EXISTS public.cipalan_q MINVALUE 0;
#perform 0002
CREATE SEQUENCE IF NOT EXISTS public.cipaxn_q MINVALUE 0;
#select  u001
SELECT '#eval    0U
'FROM v
 WHERE v.v < '1.16'
;
#begin   0002  ################
#eval    0u  ##############################################      ####
#close   U0U
#close   101
#perform 0002  #########################################################    cipalan  ####
CREATE TABLE IF NOT EXISTS public.cipalan
     ( cipalan   int4      PRIMARY KEY DEFAULT nextval('public.cipalan_q')
     , cipath    text[]    NOT NULL
     , selflock  int4
     , cipaown   int4      NOT NULL REFERENCES cipaown
     , period    interval
     , strict    bool      NOT NULL DEFAULT FALSE
     , selfgr    bool      NOT NULL DEFAULT FALSE
     , success   bool      NOT NULL DEFAULT TRUE
     , resource  bytea     NOT NULL
     , resar     int4[]
     , renul     text[]
     )
;
#perform 0002  ########################################################    cipaon  ####
CREATE TABLE IF NOT EXISTS public.cipaon
     ( cipaon    int8        PRIMARY KEY DEFAULT nextval('public.cipaxn_q')
     , cipalan   int4        REFERENCES cipalan 
     , ciparg    text[]
     , plan      timestamptz NOT NULL
     , deed      timestamptz
     , pid       int4
     , reed      timestamptz NOT NULL DEFAULT now()
     , try       int4        NOT NULL DEFAULT 0
     )
;
#perform 0002
ALTER TABLE IF EXISTS public.cipaon ALTER plan TYPE timestamptz;
#perform 0002
ALTER TABLE IF EXISTS public.cipaon ALTER deed TYPE timestamptz;
#perform 0002
ALTER TABLE IF EXISTS public.cipaon ALTER reed TYPE timestamptz;
#select  1002  #######################################################    cipacome  ####
SELECT '
 CREATE TABLE IF NOT EXISTS public.cipacome
      ( cipain    int8        PRIMARY KEY DEFAULT nextval(''public.cipaxn_q'')
      , cipalan   int4        REFERENCES cipalan
      , ciparg    text[]
      , splan     interval    NOT NULL DEFAULT ''0''
      , prii      interval    NOT NULL DEFAULT '''
                           || make_interval(0, 0, 0, 0, 0, 0, param::int)::text
                           || '''
      )
;
'FROM public.ciparam
 WHERE (m, v) = ('PKG', 'defaultprio')
;
#perform 0102
#perform 0002  ##############################################     cipacut  ####
CREATE TABLE IF NOT EXISTS public.cipacut
     ( cipain    int8      NOT NULL REFERENCES public.cipacome
     , cipaut    int8      NOT NULL REFERENCES public.cipacome
     )
;
#select  1002  #######################################################     cipago  ####
SELECT '
 CREATE TABLE IF NOT EXISTS public.cipago
     ( cipain    int8        PRIMARY KEY DEFAULT nextval(''public.cipaxn_q'')
     , cipaher   int8
     , cipalan   int4        REFERENCES cipalan
     , ciparg    text[]
     , plan      timestamptz NOT NULL DEFAULT now()
     , prii      interval    NOT NULL DEFAULT '''
                           || make_interval(0, 0, 0, 0, 0, 0, param::int)::text
                           || '''
     , try       int4        NOT NULL DEFAULT 0
     , renum     int4[]
     )
;
'FROM public.ciparam
 WHERE (m, v) = ('PKG', 'defaultprio')
;
#perform 0102
#perform 0002  ######################################################    cipaut  ####
CREATE TABLE IF NOT EXISTS public.cipaut
     ( cipain    int8      NOT NULL -- REFERENCES public.cipago
     , cipaut    int8      NOT NULL -- REFERENCES public.cipago
     , actual    bool      DEFAULT TRUE
     )
;
#select  u001
SELECT '#eval    0V
'FROM v WHERE v.v < '1.16'
;
#eval    0u  #########################################################     ####
#close   V0V
#perform 0002  ###########################     cipago.renum dorenum(cipain int8)  ####
CREATE OR REPLACE FUNCTION public.dorenum(cipain int8)
 RETURNS int[]
 AS 'SELECT array_fill(0, ARRAY[1], ARRAY[0])
         || ((SELECT CASE WHEN renum[array_upper(renum, 1)] IS NULL
                          THEN renum[:array_upper(renum, 1) - 1]
                          ELSE renum
                     END
               FROM (SELECT array_agg(public.cipadecoder(COALESCE( (cipalan.cipath || cipago.ciparg)[r]
                                                                 , n
                                                        )        )
                                      ORDER BY ordinality
                                     ) AS renum
                      FROM public.cipalan JOIN public.cipago USING(cipalan)
                         , unnest(cipalan.resar, cipalan.renul) WITH ORDINALITY AS u(r, n)
                      WHERE cipain = $1
                     GROUP BY cipain
                    )b
            ))
    '
 LANGUAGE 'sql'
 VOLATILE
 STRICT
 PARALLEL UNSAFE
;
#perform 0002
CREATE OR REPLACE FUNCTION public.dorenum(cipalan integer, ciparg text[])
 RETURNS int[]
 AS 'SELECT array_fill(0, ARRAY[1], ARRAY[0])
         || ((SELECT CASE WHEN renum[array_upper(renum, 1)] IS NULL
                          THEN renum[:array_upper(renum, 1) - 1]
                          ELSE renum
                     END
               FROM (SELECT array_agg(public.cipadecoder(COALESCE( (cipalan.cipath || $2)[r]
                                                                 , n
                                                        )        )
                                      ORDER BY ordinality
                                     ) AS renum
                      FROM public.cipalan
                         , unnest(cipalan.resar, cipalan.renul) WITH ORDINALITY AS u(r, n)
                      WHERE cipalan.cipalan = $1
                    )b
            ))
    '
 LANGUAGE 'sql'
 VOLATILE
 PARALLEL UNSAFE
;
#perform 0002
COMMENT ON FUNCTION public.dorenum(cipain int8)
 IS ',   cipago.renum'
;
#perform 0002
UPDATE public.cipago SET renum = public.dorenum(cipain);
#perform 0002
SELECT setval('public.cipalan_q', COALESCE(MAX(cipalan.cipalan) + 1, 0), FALSE) FROM public.cipalan;
#perform 0002
SELECT setval('public.cipaxn_q', COALESCE(MAX(m.m) + 1, 0), FALSE)
 FROM (SELECT MAX(cipacome.cipain) AS m FROM ONLY public.cipacome
      UNION
       SELECT MAX(cipago.cipain) AS m FROM ONLY public.cipago
      UNION
       SELECT MAX(cipaon.cipaon) AS m FROM ONLY public.cipaon
      )m
;
#perform 0002  #######################################################    ciparun  ####
CREATE UNLOGGED TABLE IF NOT EXISTS public.ciparun
     ( cipain    int8        PRIMARY KEY REFERENCES cipago
     , deed      timestamptz DEFAULT now()
     , pid       int4
     )
;
#perform 0002
ALTER TABLE IF EXISTS public.ciparun ALTER deed TYPE timestamptz;
#perform 0002
ALTER TABLE IF EXISTS public.ciparun SET UNLOGGED;
#perform 0002  #          cipaun(int8)  ####
CREATE OR REPLACE FUNCTION public.cipaun(cipain int8)
 RETURNS SETOF public.cipago
 AS '
dnl    ,   $1   ,   
      WITH y AS(SELECT i.cipain
                 FROM  public.cipago d
                  JOIN public.ciparun  USING(cipain)
                  JOIN public.cipago i USING(cipalan)
                  JOIN public.cipalan  USING(cipalan)
                 WHERE i.cipain NOT IN(SELECT cipaut.cipain FROM public.cipaut WHERE cipaut.actual)
                   AND i.cipain NOT IN(SELECT ciparun.cipain FROM public.ciparun)
                   AND d.ciparg IS NOT DISTINCT FROM i.ciparg
                   AND i.plan < ciparun.deed
                   AND i.plan < now()
                   AND cipalan.selfgr
                   AND d.cipain = $1
               UNION
                SELECT cipago.cipain FROM public.cipago WHERE cipago.cipain = $1
               )
dnl      
dnl    
         , k AS(INSERT INTO public.cipago(cipaher, cipalan, ciparg, plan, prii, renum)
                 SELECT i.cipain
                      , i.cipalan
                      , i.ciparg
                      , CASE WHEN cipalan.strict
                             THEN i.plan
                             ELSE COALESCE(ciparun.deed, now())
                        END + cipalan.period
                      , i.prii
                      , public.dorenum(i.cipain)
                  FROM       public.cipalan
                        JOIN public.cipago i USING(cipalan)
                   LEFT JOIN public.ciparun  USING(cipain)
                  WHERE i.cipain = $1
                    AND cipalan.period IS NOT NULL
                 RETURNING cipago.cipain, cipago.cipaher
               )
dnl   ciparun    
         , r AS(DELETE FROM public.ciparun
                 WHERE ciparun.cipain IN(SELECT y.cipain FROM y)
                RETURNING ciparun.cipain, deed, pid
               )
dnl   : 
         , z AS(INSERT INTO public.cipaut(cipain, cipaut)
                 SELECT k.cipain, cipago.cipain
                  FROM  k
                   JOIN public.cipaut ON(k.cipaher = cipaut.cipain)
                   JOIN public.cipago ON(cipago.cipaher = cipaut.cipaut)
               )
dnl     
         , x AS(DELETE FROM cipaut WHERE cipain IN(SELECT y.cipain FROM y))
         , w AS(UPDATE cipaut SET actual = FALSE WHERE cipaut IN(SELECT y.cipain FROM y))
dnl   cipago    
         , c AS(DELETE FROM public.cipago
                 WHERE cipago.cipain IN(SELECT y.cipain FROM y)
                RETURNING *
               )
dnl    cipaon
         , e AS(INSERT INTO public.cipaon(cipaon, cipalan, ciparg, plan, deed, pid, try)
                 SELECT cipain, cipalan, ciparg, plan, deed, pid, try
                  FROM c LEFT JOIN r USING(cipain)
                ON CONFLICT DO NOTHING
               )
dnl   
      SELECT *
       FROM c
    '
 LANGUAGE 'sql'
 VOLATILE
 STRICT
 PARALLEL UNSAFE
;
#perform 0002
COMMENT ON FUNCTION public.cipaun(cipain int8)
 IS '    RULE cipadn ON DELETE TO cipaxn,   '
;
#!#####################################################################################################
#cat     U  ################@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@  cipaxn  @@@@
cipaxn.pgoblin
#eval    0U
#close   U0U
#cat     U  ################@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@  cipaxn20  @@@@
cipaxn20.pgoblin
#eval    0U
#close   U0U
#cat     U  ################@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@  cipaxn21  @@@@
cipaxn21.pgoblin
#eval    0U
#close   U0U
#cat     U  ################@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@  cipatree()  @@@@
cipatree.pgoblin
#eval    0U
#close   U0U
#cat     U  ################@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@  cipaghost  @@@@
cipaghost.pgoblin
#eval    0U
#close   U0U
#cat     U  ################@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@  cipapan  @@@@
cipapan.pgoblin
#eval    0U
#close   U0U
#perform 0002  ################## XXXX   #####################    cipain  ####
CREATE OR REPLACE VIEW cipain AS
  SELECT cipago.cipain
       , cipago.cipaher
       , cipago.cipalan
       , u.waitout
       , cipago.ciparg
       , cipago.plan
       , date_part('epoch', cipago.prii)::int4 AS prio
       , NULL::timestamptz                    AS deed
       , NULL::int4                          AS pid
       , cipago.try
       , FALSE                             AS ghost
   FROM       public.cipago
    LEFT JOIN public.cipaut  USING(cipain)
    LEFT JOIN (SELECT cipain, NULLIF(array_remove(array_agg(cipaut), NULL), '{}') AS waitout
                FROM public.cipaut
                WHERE actual
               GROUP BY cipain
              )u             USING(cipain)
 UNION
  SELECT cipacome.cipain
       , NULL
       , cipacome.cipalan
       , u.waitout
       , cipacome.ciparg
       , '1970-01-01'::date + cipacome.splan
       , date_part('epoch', cipacome.prii)::int4 AS prio
       , NULL::timestamptz                      AS deed
       , NULL::int4                            AS pid
       , 0                                    AS try
       , TRUE                                AS ghost
   FROM       public.cipacome
    LEFT JOIN (SELECT cipain, NULLIF(array_remove(array_agg(cipaut), NULL), '{}') AS waitout
                FROM public.cipacut
               GROUP BY cipain
              )u             USING(cipain)
;
#end     0002  ################
#!#####################################################################################################
TRIGGERSETON(cipalant, public.cipalan, 2)
TRIGGERSETON(cipaint, public.cipago, 2)
TRIGGERSETON(cipautt, public.cipaut, 2)
#perform 0002
CREATE OR REPLACE FUNCTION public.cipagonext(try int4, prii interval, plan timestamptz)
 RETURNS timestamptz
 AS 'SELECT prii * (try + 1) + plan;'
 LANGUAGE 'sql'
 IMMUTABLE
 STRICT
 PARALLEL SAFE
;
#perform 0002
CREATE INDEX IF NOT EXISTS cipa_next ON public.cipago(public.cipagonext(try, prii, plan));
#perform 0002
CREATE INDEX IF NOT EXISTS cipain_t ON public.cipago(plan);
#perform 0002
CREATE INDEX IF NOT EXISTS cipain_l ON public.cipago(cipalan);
#perform 0002
CREATE INDEX IF NOT EXISTS cipaut_i ON public.cipaut(cipain);
#perform 0002
CREATE INDEX IF NOT EXISTS cipaut_a ON public.cipaut(cipaut);
#perform 0002
CREATE INDEX IF NOT EXISTS cipaut_i ON public.cipacut(cipain);
#perform 0002
CREATE INDEX IF NOT EXISTS cipaut_a ON public.cipacut(cipaut);
#perform 0002
COMMENT ON TABLE public.cipaown          IS '  ';
COMMENT ON COLUMN public.cipaown.cipaown    IS ' ';
COMMENT ON COLUMN public.cipaown.owname     IS ' ';
COMMENT ON COLUMN public.cipaown.ownpath    IS '';
#perform 0002
COMMENT ON TABLE public.cipalan          IS '  ';
COMMENT ON COLUMN public.cipalan.cipalan    IS ' ';
COMMENT ON COLUMN public.cipalan.cipath     IS 'PATH  +  ';
COMMENT ON COLUMN public.cipalan.selflock   IS '  (NULL , 0 -   , ...)';
COMMENT ON COLUMN public.cipalan.cipaown    IS '   ';
COMMENT ON COLUMN public.cipalan.period     IS ' ';
COMMENT ON COLUMN public.cipalan.strict     IS '     ';
COMMENT ON COLUMN public.cipalan.selfgr     IS '  ';
COMMENT ON COLUMN public.cipalan.success    IS '  ';
COMMENT ON COLUMN public.cipalan.resource   IS '   ';
COMMENT ON COLUMN public.cipalan.resar      IS '    ';
COMMENT ON COLUMN public.cipalan.renul      IS '   ,   resar';
#perform 0002
COMMENT ON TABLE public.cipaon           IS ' ';
COMMENT ON COLUMN public.cipaon.cipaon      IS '  ';
COMMENT ON COLUMN public.cipaon.cipalan     IS '  public.cipalan';
COMMENT ON COLUMN public.cipaon.ciparg      IS ' ';
COMMENT ON COLUMN public.cipaon.pid         IS 'PID ';
COMMENT ON COLUMN public.cipaon.plan        IS '  ';
COMMENT ON COLUMN public.cipaon.deed        IS '  ';
COMMENT ON COLUMN public.cipaon.reed        IS '  ';
COMMENT ON COLUMN public.cipaon.try         IS '  ';
#perform 0002
COMMENT ON TABLE public.cipago           IS '  ';
COMMENT ON COLUMN public.cipago.cipain      IS '  ';
COMMENT ON COLUMN public.cipago.cipaher     IS '  ';
COMMENT ON COLUMN public.cipago.cipalan     IS '  public.cipalan';
COMMENT ON COLUMN public.cipago.ciparg      IS ' ';
COMMENT ON COLUMN public.cipago.plan        IS '  ';
COMMENT ON COLUMN public.cipago.prii        IS '';
COMMENT ON COLUMN public.cipago.try         IS '  ';
COMMENT ON COLUMN public.cipago.renum       IS '   ';
#perform 0002
COMMENT ON TABLE public.cipaut           IS ' ';
COMMENT ON COLUMN public.cipaut.cipain      IS ' ';
COMMENT ON COLUMN public.cipaut.cipaut      IS ' ';
COMMENT ON COLUMN public.cipaut.actual      IS '    ';
#perform 0002
COMMENT ON TABLE public.cipacome         IS ' ';
COMMENT ON COLUMN public.cipacome.cipain    IS '  ';
COMMENT ON COLUMN public.cipacome.cipalan   IS '  public.cipalan';
COMMENT ON COLUMN public.cipacome.ciparg    IS ' ';
COMMENT ON COLUMN public.cipacome.splan     IS '  ';
COMMENT ON COLUMN public.cipacome.prii      IS '';
#perform 0002
COMMENT ON TABLE public.cipacut          IS '  ';
COMMENT ON COLUMN public.cipacut.cipain     IS ' ';
COMMENT ON COLUMN public.cipacut.cipaut     IS ' ';
#perform 0002
COMMENT ON TABLE public.ciparun          IS ' ';
COMMENT ON COLUMN public.ciparun.cipain     IS '  ';
COMMENT ON COLUMN public.ciparun.deed       IS '  ';
COMMENT ON COLUMN public.ciparun.pid        IS 'PID ';
#select  10b2  ###########################################################################    ####
SELECT 'GRANT SELECT
 ON public.cipaown
  , public.cipalan_q
  , public.cipalan
  , public.cipacome
  , public.cipacut
  , public.cipaon
  , public.cipago
  , public.cipaut
  , public.ciparun
  , public.cipaxn_q
  , public.cipain
 TO cipa, root, ' || quote_ident($1::text) || '
;
'
;
#perform 0102
#perform 0002
GRANT INSERT, UPDATE, DELETE ON public.cipago, public.ciparun TO cipa, root;
#perform 0002
GRANT INSERT ON public.cipaon TO cipa, root;
#select  10b2
SELECT 'GRANT USAGE ON public.cipaxn_q TO cipa, ' || quote_ident($1::text) || ';';
#perform 0102
#select  10b2
SELECT 'GRANT INSERT, UPDATE, DELETE ON public.cipaon, public.cipago, public.cipaut, public.ciparun
 TO cipa, root, ' || quote_ident($1::text) || '
;
'
;
#perform 0102
#select  10b2
SELECT '
 GRANT EXECUTE ON FUNCTION public.dorenum(cipain int8)
                         , public.dorenum(cipalan integer, ciparg text[])
                         , public.cipadecoder(text)
                         , public.cipaun(int8)
  TO cipa, ' || quote_ident($1::text) || '
;
'
;
#perform 0102
#perform 0002
GRANT EXECUTE ON FUNCTION public.cipagonext(try int4, prii interval, plan timestamptz) TO public;
#cat     U  ################@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@  push  @@@@
push.pgoblin
#eval    0U
#close   U0U
#cat     U  ################@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@  version  @@@@
version.pgoblin
#eval    0U
#close   U0U
#cat     U  ################@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@  cipafan  @@@@
../libexec/cipafan.pgoblin
#eval    0U
#close   U0U
#perform 0002
builtin(ifelse, PROTOVER, , SELECT public.cipaover('PKG', NULL, MAJOR, 'MINOR');
, SELECT public.cipaover('PKG', 'PROTOVER', MAJOR, 'MINOR');
)dnl
#
