#!/bin/sh -SHBANGPARM
#  Copyright (C)2021..2025 @BABOLO http://www.babolo.ru/
#--PKG = mini-cipa
#  All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#
# $Id: minicipa.m4,v 1.38 2025/08/05 22:17:18 babolo Exp $

iam="`realpath \"${0}\"`"
todo="${1}"
cd /
export TMPDIR=/tmp
export LANG=C

CIPA=`/usr/bin/basename ${0}`
CIPA_CONF=CONFDIR/${CIPA}.conf
. ${CIPA_CONF}
pidfile="/var/run/${CIPA}.pid"

if  [ -r ${pidfile} ]; then
    pidd="`/usr/bin/head -1 ${pidfile}`"
    if  [ -n "${pidd}" ]; then
        y=` /bin/ps -ax ${pidd}                                  \
          | /usr/bin/awk '/bin\/sh/{   if (  ($5 ~ /\/bin\/sh/)  \
                                          && ($6 ~ /-Tm/)        \
                                          && ($7 ~ /.*\/PROTOVER/)\
                                          ) {                    \
                                          print "yes"            \
                                   }   }                         \
                         '                                       \
          `
        if  [ "${y}" = "yes" ]; then
            /bin/kill -INT ${pidd}
            cnt=0
            while [ -r ${pidfile} -a ${cnt} -lt 20 ]; do
                /bin/sleep 1
                cnt=$(( ${cnt} + 1 ))
            done
            if  [ -r ${pidfile} ]; then
                /bin/kill -TERM ${pidd}
fi; fi; fi; fi

cnt=0
while [ -r ${pidfile} -a ${cnt} -lt 20 ]; do
    /bin/sleep 1
    cnt=$(( ${cnt} + 1 ))
done

/bin/rm -f ${pidfile}

case "${todo}" in
faststart)
    /usr/local/bin/su2 postgres \
    -- /usr/local/bin/pgoblin   \
        -Bpgsql                 \
        -d${CIPA}               \
        -s"SELECT 'Deleted from ciparun ', cipain, '
' FROM ciparun" >> /var/log/"${CIPA}".log
    /usr/local/bin/su2 postgres -- /usr/local/bin/pgoblin -Bpgsql -d${CIPA} -D'DELETE FROM ciparun'
    ;;
start|onestart)
    ;;
stop|onestop|faststop)
    exit 0
    ;;
*)
    /bin/echo "Use '(one)start' or '(one)stop'"
    /bin/echo "Used ${0} $@"
    exit
    ;;
esac

mypid=$$
/bin/echo "${mypid}" > ${pidfile}
/bin/date '+Start %F %T' ${sepa} >> ${pidfile}
zass=''
p=''
p0=''
p1=''

# --  pidfile
trap "/usr/bin/logger -t ${CIPA} -p daemon.err \"${CIPA} stops ${mypid} \`/bin/date '+%F %T'\`\"\
     ; /bin/echo \"${CIPA} stops ${mypid} \`/bin/date '+%F %T'\`\" >> /var/log/"${CIPA}".log    \
     ; /bin/rm -f ${pidfile}                                                                    \
     ; exit ${zass}                                                                             \
     " EXIT

# --    
trap " for i in \"\${p}\" \"\${p0}\" \"\${p1}\"; do\
           if  [ -n \"\${i}\" ]; then              \
               /bin/kill -TERM \${i}               \
     ;     fi                                      \
     ; done                                        \
     ; cnt=0                                       \
     ; while [ \${cnt} -lt 20 ]; do                \
           prc=0                                   \
     ;     for i in \${p} \${p0} \${p1}; do        \
               if  [ -n \"\${i}\" ]; then          \
                   if  /bin/kill -0 \${i}; then    \
                       prc=\$(( \${prc} + 1 ))     \
     ;         fi; fi                              \
     ;     done                                    \
     ;     if  [ \${prc} -eq 0 ]; then             \
               exit 0                              \
     ;     fi                                      \
     ;     /bin/sleep 1                            \
     ;     cnt=$(( ${cnt} + 1 ))                   \
     ; done                                        \
     ; exit 75                                     \
     " TERM

# --  
stop=''
trap "stop='stop'" INT

# -- endless loop, 2 workers yet
/usr/bin/logger -t ${CIPA} -p daemon.err "${CIPA} start ${mypid} \`/bin/date '+%F %T'\`"
/bin/echo "${CIPA} start ${mypid} \`/bin/date '+%F %T'\`" >> /var/log/"${CIPA}".log
while [ -z "${stop}" ]; do
    if  [ -z "${p0}" ]; then
        "${iam}_worker" 0 &
        p0=$!
    fi
    if  [ -z "${p1}" ]; then
        "${iam}_worker" 1 &
        p1=$!
    fi
    if ! /bin/kill -0 ${p0}; then
        /usr/bin/logger -t ${CIPA} -p daemon.err "${CIPA} restart 0 \`/bin/date '+%F %T'\`"
        /bin/echo "${CIPA} restart 0 \`/bin/date '+%F %T'\`" >> /var/log/"${CIPA}".log
        "${iam}_worker" 0 &
        p0=$!
    fi
    if ! /bin/kill -0 ${p1}; then
        /usr/bin/logger -t ${CIPA} -p daemon.err "${CIPA} restart 1 \`/bin/date '+%F %T'\`"
        /bin/echo "${CIPA} restart 1 \`/bin/date '+%F %T'\`" >> /var/log/"${CIPA}".log
        "${iam}_worker" 1 &
        p1=$!
    fi
    /bin/sleep 10
done
if  [ -n "${p0}" ]; then
    /bin/kill -INT ${p0}
fi
if  [ -n "${p1}" ]; then
    /bin/kill -INT ${p1}
fi
cnt=0
while [ ${cnt} -lt 20 ]; do
    /bin/sleep 1
    cnt=$(( ${cnt} + 1 ))
    prc=0
    if  [ -n "${p0}" ]; then
        if  /bin/kill -0 ${p0}; then
            prc=$(( ${prc} + 1 ))
        else
            p0=''
    fi; fi
    if  [ -n "${p1}" ]; then
        if  /bin/kill -0 ${p1}; then
            prc=$(( ${prc} + 1 ))
        else
            p1=''
    fi; fi
    if  [ ${prc} -eq 0 ]; then
        exit
    fi
done
if  [ -n "${p0}" ]; then
    /bin/kill -TERM ${p0}
fi
if  [ -n "${p1}" ]; then
    /bin/kill -TERM ${p1}
fi
cnt=0
while [ ${cnt} -lt 20 ]; do
    /bin/sleep 1
    cnt=$(( ${cnt} + 1 ))
    prc=0
    if  [ -n "${p0}" ]; then
        if  /bin/kill -0 ${p0}; then
            prc=$(( ${prc} + 1 ))
        else
            p0=''
    fi; fi
    if  [ -n "${p1}" ]; then
        if  /bin/kill -0 ${p1}; then
            prc=$(( ${prc} + 1 ))
        else
            p1=''
    fi; fi
    if  [ ${prc} -eq 0 ]; then
        exit
    fi
done
if  [ -n "${p0}" ]; then
    /bin/kill -KILL ${p0}
fi
if  [ -n "${p1}" ]; then
    /bin/kill -KILL ${p1}
fi
cnt=0
while [ ${cnt} -lt 20 ]; do
    /bin/sleep 1
    cnt=$(( ${cnt} + 1 ))
    prc=0
    if  [ -n "${p0}" ]; then
        if  /bin/kill -0 ${p0}; then
            prc=$(( ${prc} + 1 ))
        else
            p0=''
    fi; fi
    if  [ -n "${p1}" ]; then
        if  /bin/kill -0 ${p1}; then
            prc=$(( ${prc} + 1 ))
        else
            p1=''
    fi; fi
    if  [ ${prc} -eq 0 ]; then
        exit
    fi
done
