#!BINDIR/pgoblin -f
  Copyright (C)2022 @BABOLO http://www.babolo.ru/
--pkg = PKG
  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:
  1. Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.

  THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
  OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
  OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
  SUCH DAMAGE.

  $Id: xn.pgoblin.m4,v 1.1 2022/04/30 03:05:44 babolo Exp $

#echo    Q
##Q copy E
#style   00Q00Q
Q
#echo    U
##U pgo0
## help -------------------
###echo
.../xn DB [stageN]
 0 - running
 1 - resourses busy summary
 2 - waiting
 3 - blocking self
 4 - blocking params
 5 - not blocked
 9 - xn

###exit
## go -------------------
###echo
in	own*pid	lan	plan			try	path || arg

###close   _0_
###select  _002
SELECT cipain
     , cipaown || CASE WHEN deed IS NULL THEN '' ELSE '*' END || COALESCE(pid::text, '')
     , cipalan
     , to_char(plan, 'YYYY-MM-DD HH24:MI:SS')
     , try
     , cipath || ciparg
 FROM cipago JOIN cipalan USING(cipalan) LEFT JOIN ciparun USING(cipain)
ORDER BY plan
;
###display 00_00Q
###close   _0_
###exit
## xn0 -------------------
###echo
in	own*pid	lan	plan			deed		try	path || arg

###close   _0_
###select  _002
SELECT cipain
     , cipaown || CASE WHEN deed IS NULL THEN '' ELSE '*' END || COALESCE(pid::text, '')
     , cipalan
     , to_char(plan, 'YYYY-MM-DD HH24:MI:SS')
     , to_char(deed, 'DD HH24:MI:SS')
     , try
     , cipath || ciparg
 FROM cipago JOIN cipalan USING(cipalan) JOIN ciparun USING(cipain)
ORDER BY deed
;
###display 00_00Q
###close   _0_
###exit
## xn1 -------------------
###echo
hname	level	load

###close   _0_
###select  _002
WITH r AS(SELECT cipain, cipalan, renum, ciparg FROM cipago JOIN ciparun USING(cipain))
dnl     
SELECT hiename
     , cipalevel
     , bytearrsum(bytearrmask(cipalan.resource, cipamask.cipamask)) AS hieload
 FROM  cipalan
  JOIN r USING(cipalan)
     , cipamask
  JOIN unnest(renum) WITH ORDINALITY AS hiename ON(ordinality - 1 = cipalevel)
 WHERE hiename IS NOT NULL
GROUP BY hiename, cipalevel
;
###display 00_00Q
###close   _0_
###exit
## xn2 -------------------
###echo
in	wait	own	lan	plan			deed		try	path || arg

###close   _0_
###select  _002
SELECT cipago.cipain
     , cipaut.cipain
     , cipalan.cipaown
     , cipalan.cipalan
     , to_char(cipago.plan, 'YYYY-MM-DD HH24:MI:SS')
     , cipago.try
     , cipalan.cipath || cipago.ciparg
 FROM cipago JOIN cipalan USING(cipalan) JOIN cipaut USING(cipain)
 WHERE cipago.cipain NOT IN(SELECT cipain FROM ciparun)
   AND actual
ORDER BY cipago.plan
;
###display 00_00Q
###close   _0_
###exit
## xn3 -------------------
###echo
in	own	lan	plan			deed		try	path || arg

###close   _0_
###select  _002
WITH r AS(SELECT cipain, cipalan, renum, ciparg FROM cipago JOIN ciparun USING(cipain))
SELECT cipain
     , cipaown
     , cipalan
     , to_char(plan, 'YYYY-MM-DD HH24:MI:SS')
     , try
     , cipath || ciparg
 FROM cipago JOIN cipalan USING(cipalan)
 WHERE cipago.cipain NOT IN(SELECT cipain FROM ciparun)
   AND (   cipalan.selfgr
       AND cipalan.cipalan IN(SELECT cipalan
                               FROM r
                               WHERE cipago.ciparg ==* r.ciparg
                                 AND cipago.cipalan = r.cipalan
       )                     )
ORDER BY plan
;
###display 00_00Q
###close   _0_
###exit
## xn4 -------------------
###echo
in	lan	selflck	path || arg		L path || arg

###close   _0_
###select  _002
WITH r AS(SELECT cipain, cipalan, cipath, ciparg
           FROM cipago JOIN ciparun USING(cipain) JOIN cipalan USING(cipalan)
         )
SELECT cipago.cipain
     , cipalan.cipalan
     , cipalan.selflock
     , cipalan.cipath || cipago.ciparg
     , cipalan.cipath || r.ciparg
 FROM cipago
  JOIN cipalan USING(cipalan)
  JOIN r ON(compare( cipalan.selflock
                   , cipalan.cipath || cipago.ciparg
                   , r.cipath || r.ciparg
           )       )
 WHERE cipago.cipain NOT IN(SELECT cipain FROM ciparun)
;
###display 00_00Q
###close   _0_
###exit
## xn5 -------------------
###echo
in	own	lan	plan			try	path || arg

###close   _0_
###select  _002
WITH r AS(SELECT cipain, cipalan, cipath, ciparg
           FROM cipago JOIN ciparun USING(cipain) JOIN cipalan USING(cipalan)
         )
dnl   ,    selflock  selfgr    
SELECT cipain
     , cipaown
     , cipalan
     , to_char(plan, 'YYYY-MM-DD HH24:MI:SS')
     , try
     , cipath || ciparg
 FROM cipago JOIN cipalan USING(cipalan)
 WHERE cipain NOT IN(SELECT cipain FROM ciparun)
   AND cipago.cipain NOT IN(SELECT cipain FROM public.cipaut WHERE actual)
   AND NOT (   cipalan.selfgr
           AND cipalan.cipalan IN(SELECT cipalan
                                   FROM r
                                   WHERE cipago.ciparg ==* r.ciparg
                                     AND cipago.cipalan = r.cipalan
           )                     )
   AND NOT EXISTS(SELECT
                   FROM r
                   WHERE compare( cipalan.selflock
                                , cipalan.cipath || cipago.ciparg
                                , r.cipath || r.ciparg
                 )              )
ORDER BY plan
;
###display 00_00Q
###close   _0_
###exit
## xn9 -------------------
###echo
in	own*pid	lan	plan			try	ready	path || arg

###close   _0_
###select  _002
SELECT cipain
     , cipaown || CASE WHEN deed IS NULL THEN '' ELSE '*' END || COALESCE(pid::text, '')
     , cipalan
     , to_char(plan, 'YYYY-MM-DD HH24:MI:SS')
     , try
     , ready
     , cipath || ciparg
 FROM cipaxn JOIN cipalan USING(cipalan) LEFT JOIN ciparun USING(cipain)
ORDER BY plan
;
###display 00_00Q
###exit
###close   _0_
#style   00U00U -------------------
U
#connect 0001
sqlite3 :memory:
#perform 0001
CREATE TEMP TABLE a(i int, a text);
#getarg  _
#copyin  00_1
COPY a FROM stdin;
#close   _0_
#perform 0001
CREATE TEMP TABLE x(db text, n int);
#perform 0001
INSERT INTO x
 SELECT (SELECT a FROM a WHERE i = 0 AND a REGEXP '^[_a-z][_a-z0-9]*$' LIMIT 1)
      , (SELECT a FROM a WHERE i = 1 AND a REGEXP '^[0-9]+$' LIMIT 1)
;
#select  _001
SELECT 'help' FROM x WHERE db IS NULL;
#echo    u_000U
#eval    0u
#close   u0u
#close   _0_
#clear   u
#select  _001
SELECT 'pgsql dbname=' || db || ' requirepeer=postgres application_name=PKG_' || 'xn'
 FROM x
;
#connect 0_02
#close   _0_
#select  _001
SELECT 'go' FROM x WHERE n IS NULL;
#echo    u_000U
#eval    0u
#close   u0u
#close   _0_
#clear   u
#select  _001
SELECT 'xn' || n FROM x;
#echo    u_000U
#eval    0u
#close   u0u
#close   _0_
#clear   u
#exit