#!BINDIR/pgoblin -f
  Copyright (C)2019..2022 @BABOLO http://www.babolo.ru/
--pkg = PKG
  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:
  1. Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.

  THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
  OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
  OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
  SUCH DAMAGE.

  $Id: test0.pgoblin.m4,v 1.14 2022/04/30 03:05:44 babolo Exp $

#connect 0001
CIPADBMS
GETARG(, 1, 1)
#echo    Q
##Q copy E
#style   00Q00Q
Q
#perform 0001
CREATE TEMP TABLE x
     ( b text    --    (PROTOVER)  'minicipa'
     , a text    --    (PROTOVER)
     )
;
#perform 0001
INSERT INTO x
 SELECT COALESCE( (SELECT a FROM a WHERE i = 0 AND regexp('^[a-z0-9_]+$', a))
                , 'minicipa'
                )
      , (SELECT a FROM a WHERE i = 0 AND regexp('^[a-z0-9_]+$', a))
;
#select  b001  #################################################################  b - ${PROTOVER}  ####
SELECT b FROM x;
#select  10b1
SELECT 'pgsql dbname=' || ? || ' requirepeer=postgres application_name=minicipa_test0';
#connect 0102
#perform 0002
CREATE TEMP SEQUENCE inlog_q MINVALUE 0;
#perform 0002
CREATE TEMP TABLE inlog
     ( logn      int       PRIMARY KEY DEFAULT nextval('inlog_q')
     , nn        text
     , m         text
     , v         text
     , cipain    int8
     , cipaher   int8
     , cipalan   int4
     , waitout   int8[]
     , ciparg    text[]
     , plan      timestamp
     , prio      int4
     , try       int4
     , ghost     bool
     , renum     int4[]
     )
;
#perform 0002
CREATE TEMP TABLE i(cipain int8);
#perform 0002
CREATE TRIGGER ii
 AFTER INSERT ON i
 FOR EACH STATEMENT
 EXECUTE PROCEDURE public.topute('tst onl', 'a', 'i')
;
#perform 0002
CREATE TRIGGER iu
 AFTER UPDATE ON i
 FOR EACH STATEMENT
 EXECUTE PROCEDURE public.topute('tst onl', 'a', 'u')
;
#perform 0002
CREATE TRIGGER id
 AFTER DELETE ON i
 FOR EACH STATEMENT
 EXECUTE PROCEDURE public.topute('tst onl', 'a', 'd')
;
#begin   0002
#perform 0002
TRUNCATE public.cipaghost
       , public.ciparun
       , public.cipacut
       , public.cipacome
       , public.cipaut
       , public.cipago
       , public.cipaon
       , public.cipalan
       , public.cipaown
       , public.cipamask
;
#perform 0002
INSERT INTO public.cipamask
 VALUES (0, '111111')
      , (1, '000000111')
      , (2, '000000000111')
;
#perform 0002
INSERT INTO public.cipaown VALUES(0, 'tst onl', '{/usr/local/bin/su2,test,--}');
#perform 0002
INSERT INTO public.cipalan(cipalan, cipath, selflock, cipaown, period, selfgr, resource, resar, renul)
 VALUES (0, '{/bin/echo}'    , NULL, 0, NULL, FALSE, '\x307830', NULL, NULL)
      , (1, '{/bin/echo,a}'  , NULL, 0, NULL, FALSE, '\x307830', '{2, NULL}', NULL)
      , (2, '{/bin/echo,a,b}', NULL, 0, NULL, FALSE, '\x307830', '{3, NULL}', '{NULL, a}')
      , (3, '{/bin/echo}'    , NULL, 0, '1d', FALSE, '\x307830', NULL, NULL)
;
#perform 0002
INSERT INTO public.cipacome(cipain, cipalan, ciparg, splan)
 VALUES (0, 0, NULL   , DEFAULT)
      , (1, 1, '{a}'  , DEFAULT)
      , (2, 2, '{a,b}', DEFAULT)
      , (3, 2, NULL   , DEFAULT)
      , (4, 3, NULL   , DEFAULT)
;
#perform 0002
INSERT INTO public.cipacut
 VALUES (0, 1)
      , (0, 2)
      , (1, 2)
;
#perform 0002
INSERT INTO public.cipaghost
 VALUES ('tst onl', 'o', 0)
      , ('tst onl', 'a', 1)
      , ('tst onl', 'b', 2)
      , ('tst onl', 'c', 3)
;
#perform 0002
GRANT ALL ON SEQUENCE inlog_q TO cipa, root;
#perform 0002
GRANT ALL ON inlog, i TO cipa, root;
#perform 0002
SET ROLE cipa;
#echo
######## cipamask
cipalevel cipamask

#select  q002
SELECT * FROM public.cipamask;
#display 00q00Q
#echo
######## cipalan
cipalan	cipath		selflock cipaown period	strict	selfgr	success	resource	resar	renul

#select  q002
SELECT * FROM public.cipalan;
#display 00q00Q
#echo
######## cipaup
m	v	cipain	cipalan	ciparg		plan			prio

#select  q002
SELECT * FROM public.cipaup;
#display 00q00Q
#echo
######## cipacome
cipain	cipalan	ciparg	splan		prio

#select  q002
SELECT * FROM public.cipacome;
#display 00q00Q
#echo
######## cipacut
cipain	cipaut

#select  q002
SELECT * FROM public.cipacut;
#display 00q00Q
#echo
######## cipatree(0)
cipain	cipalan	ciparg	splan		prio

#select  q002
SELECT * FROM public.cipatree(0);
#display 00q00Q
#echo
######## cipatree(1)
cipain	cipalan	ciparg	splan		prio

#select  q002
SELECT * FROM public.cipatree(1);
#display 00q00Q
#echo
######## cipatree(2)
cipain	cipalan	ciparg	splan		prio

#select  q002
SELECT * FROM public.cipatree(2);
#display 00q00Q
#echo
######## cipatree(3)
cipain	cipalan	ciparg	splan		prio

#select  q002
SELECT * FROM public.cipatree(3);
#display 00q00Q
#echo
######## cipatree(4)
cipain	cipalan	ciparg	splan		prio

#select  q002
SELECT * FROM public.cipatree(4);
#display 00q00Q
#echo
######## cipatree(5)
cipain	cipalan	ciparg	splan		prio

#select  q002
SELECT * FROM public.cipatree(5);
#display 00q00Q
#echo
    #########################################        cipaup  ####

#perform 0002
WITH a AS(UPDATE public.cipaup
             SET plan = now() + '1s'::interval, ciparg = ARRAY['x'::text]
           WHERE (m, v) = ('tst onl', 'a')
          RETURNING *
         )
INSERT INTO inlog(nn, m, v, cipain, cipalan, ciparg, plan, prio)
 SELECT 'ina', a.* FROM a
;
#perform 0002
WITH a AS(UPDATE public.cipaup SET prio = NULL WHERE (m, v) = ('tst onl', 'b') RETURNING *)
INSERT INTO inlog(nn, m, v, cipain, cipalan, ciparg, plan, prio)
 SELECT 'inb', a.* FROM a
;
#perform 0002
WITH a AS(UPDATE public.cipaup
             SET m = '', ciparg = ARRAY['z'::text]
           WHERE (m, v) = ('tst onl', 'o')
          RETURNING *
         )
INSERT INTO inlog(nn, m, v, cipain, cipalan, ciparg, plan, prio)
 SELECT 'ino', a.* FROM a
;
#echo  ################################################################################################
######## inlog
logn	nn	m	v	cipain	cipaher	cipalan	waitout	ciparg		plan			prio	try	ghost	renum

#select  q002
SELECT * FROM inlog;
#display 00q00Q
#echo
######## cipago
cipain	cipaher	cipalan	ciparg		plan			prio		try	renum

#select  q002
SELECT * FROM public.cipago ORDER BY cipain;
#display 00q00Q
#echo
######## cipaxn
cipain	cipaher	cipalan	ciparg		plan			prio		try	renum		ready

#select  q002
SELECT * FROM public.cipaxn ORDER BY cipain;
#display 00q00Q
#echo
######## cipaxn20
cipain	cipaher	cipalan	ciparg		plan			prio		try	renum		ready

#select  q002
SELECT * FROM public.cipaxn20 ORDER BY cipain;
#display 00q00Q
#echo
######## cipaxn21
cipain	cipaher	cipalan	ciparg		plan			prio	try	renum		ready

#select  q002
SELECT * FROM public.cipaxn21 ORDER BY cipain;
#display 00q00Q
#echo
######## cipaut
cipain	cipaut	actual

#select  q002
SELECT * FROM public.cipaut;
#display 00q00Q
#echo
######## cipain
cipain	cipaher	cipalan	waitout	ciparg		plan		prio	deed	pid	try	ghost

#select  q002
SELECT cipain
     , cipaher
     , cipalan
     , waitout
     , ciparg
     , to_char(plan, 'YYYY-MM-DD HH24:MI:SS')
     , prio
     , deed
     , pid
     , try
     , ghost
 FROM public.cipain
ORDER BY cipain
;
#display 00q00Q
#echo
    ######################################################        ####

#select  _002
SELECT cipain FROM public.cipaxn WHERE ready ORDER BY cipain DESC LIMIT 1;
#perform 00_2
WITH a AS(INSERT INTO ciparun(cipain) VALUES($1::int8) RETURNING *)
INSERT INTO inlog(nn, cipain, plan, try)
 SELECT 'run1', a.cipain, a.deed, a.pid FROM a
;
#echo
######## ciparun
cipain		deed			pid

#select  q002
SELECT * FROM ciparun;
#display 00q00Q
#echo
    ########################################################################     ####

#perform 00_2
INSERT INTO inlog(nn, cipain, cipaher, cipalan, ciparg, plan, prio, try, renum)
 SELECT 'dixi1', cipain, cipaher, cipalan, ciparg, plan, date_part('epoch', prii)::int4, try, renum
  FROM cipaun($1::int8)
;
#echo  ################################################################################################
######## inlog
logn	nn	m	v	cipain	cipaher	cipalan	waitout	ciparg		plan			prio	try	ghost	renum

#select  q002
SELECT * FROM inlog;
#display 00q00Q
#echo
######## ciparun
cipain		deed			pid

#select  q002
SELECT * FROM ciparun;
#display 00q00Q
#echo
######## cipaon
cipaon	cipalan	ciparg		plan				deed			pid		reed			try

#select  q002
SELECT * FROM public.cipaon;
#display 00q00Q
#echo
######## cipaut
cipain	cipaut	actual

#select  q002
SELECT * FROM public.cipaut;
#display 00q00Q
#echo
######## cipaxn
cipain	cipaher	cipalan	ciparg		plan			prio		try	renum		ready

#select  q002
SELECT * FROM public.cipaxn ORDER BY cipain;
#display 00q00Q
#echo
######## cipaxn20
cipain	cipaher	cipalan	ciparg		plan			prio		try	renum		ready

#select  q002
SELECT * FROM public.cipaxn20 ORDER BY cipain;
#display 00q00Q
#echo
######## cipaxn21
cipain	cipaher	cipalan	ciparg		plan			prio	try	renum		ready

#select  q002
SELECT * FROM public.cipaxn21 ORDER BY cipain;
#display 00q00Q
#echo
    ##################################################   3      ####

#select  _002
SELECT cipain FROM public.cipaxn WHERE ready ORDER BY cipain DESC LIMIT 3;
#perform 00_2
WITH a AS(INSERT INTO ciparun(cipain) VALUES($1::int8) RETURNING *)
INSERT INTO inlog(nn, cipain, plan, try)
 SELECT 'run3', a.cipain, a.deed, a.pid FROM a
;
#echo
######## ciparun
cipain		deed			pid

#select  q002
SELECT * FROM ciparun;
#display 00q00Q
#echo
######## cipaxn
cipain	cipaher	cipalan	ciparg		plan			prio		try	renum		ready

#select  q002
SELECT * FROM public.cipaxn ORDER BY cipain;
#display 00q00Q
#echo
    ########################################################################     ####

#perform 00_2
INSERT INTO inlog(nn, cipain, cipaher, cipalan, ciparg, plan, prio, try, renum)
 SELECT 'dixi3', cipain, cipaher, cipalan, ciparg, plan, date_part('epoch', prii)::int4, try, renum
  FROM cipaun($1::int8)
;
#echo  ################################################################################################
######## inlog
logn	nn	m	v	cipain	cipaher	cipalan	waitout	ciparg		plan			prio	try	ghost	renum

#select  q002
SELECT * FROM inlog;
#display 00q00Q
#echo
######## ciparun
cipain		deed			pid

#select  q002
SELECT * FROM ciparun;
#display 00q00Q
#echo
######## cipaon
cipaon	cipalan	ciparg		plan				deed			pid		reed			try

#select  q002
SELECT * FROM public.cipaon;
#display 00q00Q
#echo
######## cipaxn
cipain	cipaher	cipalan	ciparg		plan			prio		try	renum		ready

#select  q002
SELECT * FROM public.cipaxn ORDER BY cipain;
#display 00q00Q
#echo
    ################################################################    i, u  d  ####

#perform 00_2
WITH a AS(INSERT INTO i(cipain) SELECT $1::int8 RETURNING *)
INSERT INTO inlog(nn, cipain)
 SELECT 'tri', a.* FROM a
;
#echo
######## cipago
cipain	cipaher	cipalan	ciparg		plan			prio		try	renum

#select  q002
SELECT * FROM public.cipago ORDER BY cipain;
#display 00q00Q
#perform 00_2
WITH a AS(UPDATE i SET cipain = $1 RETURNING *)
INSERT INTO inlog(nn, cipain)
 SELECT 'tru', a.cipain FROM a
;
#echo
######## cipago
cipain	cipaher	cipalan	ciparg		plan			prio		try	renum

#select  q002
SELECT * FROM public.cipago ORDER BY cipain;
#display 00q00Q
#perform 0002
WITH a AS(DELETE FROM i RETURNING *)
INSERT INTO inlog(nn, cipain)
 SELECT 'trd', a.cipain FROM a
;
#echo
######## cipago
cipain	cipaher	cipalan	ciparg		plan			prio		try	renum

#select  q002
SELECT * FROM public.cipago ORDER BY cipain;
#display 00q00Q
#echo
######## cipaut
cipain	cipaut	actual

#select  q002
SELECT * FROM public.cipaut;
#display 00q00Q
#echo
######## inlog
logn	nn	m	v	cipain	cipaher	cipalan	waitout	ciparg		plan			prio	try	ghost	renum

#select  q002
SELECT * FROM inlog;
#display 00q00Q
#perform 0002
ROLLBACK;
#
