#!/usr/local/bin/pgoblin -f
  Copyright (C)2020..2021 @BABOLO http://www.babolo.ru/
--PKG = mini-cipa
  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:
  1. Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.

  THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
  OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
  OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
  SUCH DAMAGE.

  $Id: push.pgoblin.m4,v 1.11 2021/11/29 17:08:50 cuhegh Exp $

#! ############################@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@  push  @@@@
#perform 0002  ############################################################################  mode  ####
CREATE SEQUENCE IF NOT EXISTS public.cipamode_q;
#perform 0002
CREATE TABLE IF NOT EXISTS public.cipamode
     ( mode int  PRIMARY KEY DEFAULT nextval('public.cipamode_q')
     , mnam text NOT NULL
     , opaq text[]
     )
;
#perform 0002
ALTER SEQUENCE public.cipamode_q OWNED BY public.cipamode.mode;
#perform 0002
CREATE OR REPLACE RULE cipamode_r AS ON INSERT TO public.cipamode DO NOTHING;
#perform 0002
COMMENT ON TABLE public.cipamode       IS '   ';
COMMENT ON COLUMN public.cipamode.mode    IS ' ';
COMMENT ON COLUMN public.cipamode.mnam    IS '   ';
COMMENT ON COLUMN public.cipamode.opaq    IS '  ';
#perform 0002  ############################################################################  list  ####
CREATE SEQUENCE IF NOT EXISTS public.cipalist_q;
#perform 0002
CREATE TABLE IF NOT EXISTS public.cipalist
     ( list int  PRIMARY KEY DEFAULT nextval('public.cipalist_q')
     , dnam text NOT NULL UNIQUE
     )
;
#perform 0002
ALTER SEQUENCE public.cipalist_q OWNED BY public.cipalist.list;
#perform 0002
COMMENT ON TABLE public.cipalist       IS '   ';
COMMENT ON COLUMN public.cipalist.list    IS '   ';
COMMENT ON COLUMN public.cipalist.dnam    IS '    ';
#perform 0002  ############################################################################  padr  @@@@
CREATE TABLE IF NOT EXISTS public.cipapadr
     ( list int  NOT NULL REFERENCES public.cipalist
     , mode int  NOT NULL REFERENCES public.cipamode
     , padr text NOT NULL
     )
;
#perform 0002
CREATE INDEX IF NOT EXISTS cipapadr_x ON public.cipapadr(list);
#perform 0002
COMMENT ON TABLE public.cipapadr       IS ' ';
COMMENT ON COLUMN public.cipapadr.list    IS '   ';
COMMENT ON COLUMN public.cipapadr.mode    IS '   ';
COMMENT ON COLUMN public.cipapadr.padr    IS 'mode ';
#perform 0002  ############################################################################  mess  ####
CREATE SEQUENCE IF NOT EXISTS public.cipamess_q;
#perform 0002
CREATE TABLE IF NOT EXISTS public.cipamess
     ( mess int8 PRIMARY KEY DEFAULT nextval('public.cipamess_q')
     , mtxt text NOT NULL
     )
;
#perform 0002
ALTER SEQUENCE public.cipamess_q OWNED BY public.cipamess.mess;
#perform 0002
COMMENT ON TABLE public.cipamess       IS '';
COMMENT ON COLUMN public.cipamess.mess    IS ' ';
COMMENT ON COLUMN public.cipamess.mtxt    IS ' ';
#select  10b2
SELECT '
 GRANT USAGE ON public.cipamode_q, public.cipalist_q, public.cipamess_q
  TO cipa, root, operator, ' || quote_ident($1::text) || '
;
'
;
#perform 0102
#select  10b2
SELECT '
 GRANT SELECT ON public.cipamode, public.cipalist, public.cipapadr, public.cipamess
  TO cipa, root, operator, ' || quote_ident($1::text) || '
;
'
;
#perform 0102
#select  10b2
SELECT '
 GRANT ALL ON public.cipalist, public.cipapadr, public.cipamess
  TO cipa, root, ' || quote_ident($1::text) || '
;
'
;
#perform 0102
#select  10b2
SELECT '
 GRANT INSERT ON public.cipalist, public.cipapadr, public.cipamess
  TO operator, ' || quote_ident($1::text) || '
;
'
;
#perform 0102
#begin   0002
#perform 0002  ################################################################  cipaown PROTOVER  ####
INSERT INTO public.cipaown(owname, ownpath)
 SELECT 'PROTOVER', ARRAY['/usr/local/bin/su2', 'PROTOVER', '--']
ON CONFLICT DO NOTHING
;
#select  1002
INSERT INTO public.cipalan(cipath, selflock, cipaown, selfgr, success, resource)
 SELECT ARRAY['/usr/local/bin/cipa', 'PKG', 'push']
      , 3
      , (SELECT cipaown FROM public.cipaown WHERE owname = 'PROTOVER')
      , TRUE
      , FALSE
      , '\x00'
  WHERE NOT EXISTS(SELECT
                    FROM public.cipalan
                    WHERE cipath = ARRAY['/usr/local/bin/cipa', 'PKG', 'push']
                      AND period IS NULL
                  )
RETURNING cipalan
;
#perform 0012
INSERT INTO public.cipapan
 SELECT 'PKG', 'push', $1
;
#end     0002
#begin   0002
#perform 0002  ################################################################  cipaown postgres  ####
INSERT INTO public.cipaown(owname, ownpath)
 SELECT 'postgres', ARRAY['/usr/local/bin/su2', 'postgres', '--']
ON CONFLICT DO NOTHING
;
#select  1002
INSERT INTO public.cipalan(cipath, selflock, cipaown, selfgr, strict, success, period, resource)
 SELECT ARRAY['/usr/local/bin/cipa', 'PKG', 'big_servant', 'PROTOVER']
      , 3
      , (SELECT cipaown FROM public.cipaown WHERE owname = 'postgres')
      , TRUE
      , TRUE
      , FALSE
      , '1week'
      , '\x00'
  WHERE NOT EXISTS(SELECT
                    FROM public.cipalan
                    WHERE cipath = ARRAY['/usr/local/bin/cipa', 'PKG', 'big_servant', 'PROTOVER']
                      AND period IS NOT NULL
                  )
RETURNING cipalan
;
#end     0002
