#!/usr/local/bin/pgoblin -f
  Copyright (C)2019..2021 @BABOLO http://www.babolo.ru/
--PKG = mini-cipa
  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:
  1. Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.

  THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
  OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
  OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
  SUCH DAMAGE.

  $Id: dossier.pgoblin.m4,v 1.10 2021/07/31 09:04:41 babolo Exp $

#perform 0002  ############################################       ####
CREATE SEQUENCE IF NOT EXISTS public.cipadecod_q MINVALUE 0;
#perform 0002
CREATE TABLE IF NOT EXISTS public.cipadecod
     ( enco       text   PRIMARY KEY
     , deco       int4   DEFAULT nextval('public.cipadecod_q')
     )
;
#perform 0002
SELECT setval('public.cipadecod_q', COALESCE(MAX(cipadecod.deco) + 1, 0), FALSE) FROM public.cipadecod;
#perform 0002
COMMENT ON TABLE public.cipadecod      IS '    ';
COMMENT ON COLUMN public.cipadecod.enco   IS '';
COMMENT ON COLUMN public.cipadecod.deco   IS '';
#perform 0002  ####################################         ####
CREATE OR REPLACE FUNCTION public.cipadecoder(text)
 RETURNS int4
 AS $$WITH s AS(SELECT CASE WHEN $1 ~ '^[0-9]+$'
                            THEN $1::int4
                            ELSE -deco
                       END AS deco
                 FROM public.cipadecod WHERE enco = $1
               )
         , r AS(INSERT INTO public.cipadecod(enco)
                 SELECT $1 WHERE NOT EXISTS(SELECT 1 FROM s)
                ON CONFLICT DO NOTHING
                RETURNING deco
               )
      SELECT deco
       FROM(SELECT deco, 0 AS p FROM s UNION SELECT -deco, 2 FROM r)d
      ORDER BY p
      LIMIT 1
    $$
 LANGUAGE 'sql'
 VOLATILE
 STRICT
 PARALLEL UNSAFE
;
#perform 0002
COMMENT ON FUNCTION public.cipadecoder(text)
 IS '.       '
;
#perform 0002  #####################################  -   tocipa()  ####
CREATE OR REPLACE FUNCTION public.tocipa() RETURNS trigger AS
$tocipa$
    BEGIN
        NOTIFY cipaxn;
        RETURN NULL;
    END;
$tocipa$
 LANGUAGE 'plpgsql'
;
#perform 0002
COMMENT ON FUNCTION public.tocipa() IS '     ';
#perform 0002  ###################################################    ciparam  ####
CREATE TABLE IF NOT EXISTS public.ciparam
     ( m      text
     , v      text
     , param  text
     , PRIMARY KEY(m, v)
     )
;
TRIGGERSETON(ciparamt, public.ciparam, 2)
#perform 0002
INSERT INTO public.ciparam
 SELECT 'PKG', 'timeout', '56min'
ON CONFLICT DO NOTHING
;
#perform 0002
INSERT INTO public.ciparam
 SELECT 'PKG', 'defaultprio', '1000'
ON CONFLICT DO NOTHING
;
#perform 0002
COMMENT ON TABLE public.ciparam        IS '  ';
COMMENT ON COLUMN public.ciparam.m        IS ',   ̣ ';
COMMENT ON COLUMN public.ciparam.v        IS '   ';
COMMENT ON COLUMN public.ciparam.param    IS ' ';
#perform 0002  #################################################################   cipares  ####
CREATE SEQUENCE IF NOT EXISTS public.cipares_q MINVALUE 0;
#perform 0002
CREATE TABLE IF NOT EXISTS public.cipares
     ( cipares    int4     PRIMARY KEY DEFAULT nextval('public.cipares_q')
     , ciparesnm  text     NOT NULL UNIQUE
     )
;
#perform 0002
SELECT setval('public.cipares_q', COALESCE(MAX(cipares.cipares) + 1, 0), FALSE) FROM public.cipares;
#perform 0002
COMMENT ON TABLE public.cipares          IS '  ';
COMMENT ON COLUMN public.cipares.cipares    IS ' ';
COMMENT ON COLUMN public.cipares.ciparesnm  IS ' ';
#perform 0002  #########################################################    cipamask  ####
CREATE SEQUENCE IF NOT EXISTS public.cipalevel_q MINVALUE 0;
#perform 0002
ALTER SEQUENCE public.cipalevel_q MINVALUE 0;
#perform 0002
CREATE TABLE IF NOT EXISTS public.cipamask
     ( cipalevel int4      PRIMARY KEY DEFAULT nextval('public.cipalevel_q')
     , cipamask  varbit    NOT NULL
     )
;
TRIGGERSETON(cipamaskt, public.cipamask, 2)
#perform 0002
SELECT setval('public.cipalevel_q', COALESCE(MAX(cipamask.cipalevel) + 1, 0), FALSE)
 FROM public.cipamask
;
#perform 0002
COMMENT ON TABLE public.cipamask         IS '     ';
COMMENT ON COLUMN public.cipamask.cipalevel IS '  ';
COMMENT ON COLUMN public.cipamask.cipamask  IS ' ';
#select  10b2  ###########################################################################    ####
SELECT '
 GRANT SELECT
  ON public.cipares_q
   , public.cipares
   , public.ciparam
   , public.cipamask
   , public.cipalevel_q
   , public.cipadecod
  TO cipa, root, ' || quote_ident($1::text) || '
;
'
;
#perform 0102
#select  10b2
SELECT 'GRANT USAGE ON public.cipadecod_q TO cipa, root, ' || quote_ident($1::text) || ';';
#perform 0102
#select  10b2
SELECT 'GRANT INSERT ON public.cipadecod TO cipa, root, ' || quote_ident($1::text) || ';';
#perform 0102
#select  10b2
SELECT '
 GRANT EXECUTE ON FUNCTION public.cipadecoder(text), public.tocipa()
  TO cipa, root, ' || quote_ident($1::text) || '
;
'
;
#perform 0102
