#!/usr/local/bin/pgoblin -f
  Copyright (C)2019..2021 @BABOLO http://www.babolo.ru/
--PKG = mini-cipa
  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:
  1. Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.

  THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
  OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
  OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
  SUCH DAMAGE.

  $Id: cipapan.pgoblin.m4,v 1.9 2021/07/31 09:04:41 babolo Exp $

#perform 0002  ##################################     VIEW cipato cipone(...)  ####
CREATE OR REPLACE FUNCTION public.cipone
     ( cipalan int4
     , waitout int8[]
     , ciparg  text[]
     , plan    timestamptz
     , prio    int4
     )
 RETURNS SETOF public.cipago
 AS ' NOTIFY cipaxn
dnl     cipago
    ; WITH x AS(INSERT INTO public.cipago(cipalan, ciparg, plan, prii, renum)
                 SELECT cipalan.cipalan
                      , $3
                      , COALESCE($4, now())
                      , make_interval( 0
                                     , 0
                                     , 0
                                     , 0
                                     , 0
                                     , 0
                                     , COALESCE( $5
                                               , (SELECT param::int4
                                                   FROM public.ciparam
                                                   WHERE (m, v) = (''PKG'', ''defaultprio'')
                                                 )
                                               , 4000
                                     )         )
                      , public.dorenum(cipalan.cipalan, $3)
                  FROM public.cipalan
                  WHERE cipalan.cipalan = $1
                RETURNING cipago.*
               )
         , u AS(INSERT INTO public.cipaut(cipain, cipaut)
                 SELECT DISTINCT x.cipain, cipaut
                  FROM x, unnest($2)cipaut
                  WHERE cipaut IS NOT NULL
               )
      SELECT x.cipain, x.cipaher, x.cipalan, x.ciparg, x.plan, x.prii, x.try, x.renum FROM x
    ;
    '
 LANGUAGE 'sql'
 VOLATILE
 PARALLEL UNSAFE
;
#perform 0002
COMMENT ON FUNCTION public.cipone
     ( cipalan int4
     , waitout int8[]
     , ciparg  text[]
     , plan    timestamptz
     , prio    int4
     )
 IS ',   cipalan  ,  (cipain, waitout, ciparg, plan, prio)'
;
#perform 0002  #############################  API      cipapan  ####
CREATE TABLE IF NOT EXISTS public.cipapan
     ( m       text
     , v       text
     , cipalan int REFERENCES cipalan
     , PRIMARY KEY(m, v)
     )
;
#perform 0002
COMMENT ON TABLE public.cipapan        IS '   ';
COMMENT ON COLUMN public.cipapan.m        IS '  - ';
COMMENT ON COLUMN public.cipapan.v        IS '    ';
COMMENT ON COLUMN public.cipapan.cipalan  IS '  cipalan.cipalan';
#perform 0002  #######################################  API      cipato  ####
CREATE OR REPLACE VIEW public.cipato AS
 SELECT cipapan.m
      , cipapan.v
      , NULL::int8   AS cipain
      , cipalan
      , NULL::text[] AS ciparg
      , now()        AS plan
      , param::int4  AS prio
      , NULL::int4[] AS renum
  FROM public.cipapan JOIN public.cipalan USING(cipalan)
     , public.ciparam
  WHERE (ciparam.m, ciparam.v) = ('PKG', 'defaultprio')
;
#perform 0002
CREATE OR REPLACE RULE cipauto AS
    ON UPDATE TO public.cipato
    DO INSTEAD
    ( UPDATE public.fake
         SET fake = NULL
       FROM public.cipapan, public.cipone(OLD.cipalan, NULL, NEW.ciparg, NEW.plan, NEW.prio)t
       WHERE (cipapan.m, cipapan.v, cipapan.cipalan) = (OLD.m, OLD.v, OLD.cipalan)
      RETURNING cipapan.m
              , cipapan.v
              , t.cipain
              , t.cipalan
              , t.ciparg
              , t.plan
              , date_part('epoch', t.prii)::int4
              , t.renum
    )
;
#perform 0002
COMMENT ON VIEW public.cipato            IS '  ';
COMMENT ON COLUMN public.cipato.m           IS '  - ';
COMMENT ON COLUMN public.cipato.v           IS '    ';
COMMENT ON COLUMN public.cipato.cipain      IS ' ';
COMMENT ON COLUMN public.cipato.cipalan     IS '  public.cipalan';
COMMENT ON COLUMN public.cipato.ciparg      IS ' ';
COMMENT ON COLUMN public.cipato.plan        IS '  ';
COMMENT ON COLUMN public.cipato.prio        IS '';
#perform 0002  ####################################  API -   tolate()  ####
CREATE OR REPLACE FUNCTION public.tolate() RETURNS trigger
 AS 'BEGIN
        PERFORM
         FROM public.cipapan
            , public.cipone(cipapan.cipalan, NULL, TG_ARGV[2:], NULL, NULL)
         WHERE (cipapan.m, cipapan.v) = (TG_ARGV[0], TG_ARGV[1])
    ;
         RETURN NULL;
     END;
    '
LANGUAGE 'plpgsql'
;
#perform 0002
COMMENT ON FUNCTION public.tolate() IS '      cipalan';
#select  10b2  ###########################################################################    ####
SELECT '
 GRANT SELECT
  ON public.cipapan, public.cipato
  TO cipa, root, ' || quote_ident($1::text) || '
;
'
;
#perform 0102
#select  10b2
SELECT 'GRANT UPDATE ON public.cipato TO cipa, ' || quote_ident($1::text) || ';';
#perform 0102
#select  10b2
SELECT '
 GRANT EXECUTE
  ON FUNCTION public.cipone(cipalan int4, waitout int8[], ciparg text[], plan timestamptz, prio int4)
            , public.tolate()
  TO cipa, root, ' || quote_ident($1::text) || '
;
'
;
#perform 0102
