#!/bin/sh
# Copyright (C)2022..2025 @BABOLO http://www.babolo.ru/
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS "AS IS" AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#
# $Id: param.sh,v 1.19 2025/12/14 23:11:13 babolo Exp $

dir="${1}"

if [ -z "${dir}" ]; then
   echo "Usage: ${0} DIR"
   echo "where DIR for param.make"
   exit 1
fi

mk="${dir}/param.make"

head  -27 "${0}" | tail -26 > "${mk}"

mktemp=`which mktemp`

if [ -z "${mktemp}" ]; then
   echo "mktemp not found"
   exit 1
fi

WLIST="-fdebug-cpp -fdebug-macro -fkeep-static-consts -fstack-protector -fstrict-aliasing           \
       -fstrict-overflow -fstandalone-debug -ftrapv -fno-eliminate-unused-debug-types               \
       -Wall -Wextra -Weverything -Wdocumentation -Wmost -pedantic                                  \
       -Warray-bounds -Warray-bounds=2 -Wbad-function-cast -Wcast-align -Wcast-qual -Wclobbered     \
       -Wconversion -Wdeclaration-after-statement -Wdisabled-optimization -Wfloat-equal -Winit-self \
       -Wformat-signedness -Wformat-y2k -Wformat=2 -Winline -Wjump-misses-init -Wmissing-prototypes \
       -Wlogical-op -Wmisleading-indentation -Wmissing-declarations -Wmissing-include-dirs -Wpacked \
       -Wnested-externs -Wnull-dereference -Wpointer-arith -Wsequence-point                         \
       -Wold-style-definition -Woverflow -Wpadded -Wparentheses -Wredundant-decls -Wshadow -Wunused \
       -Wstack-protector -Wstrict-overflow=5 -Wstrict-prototypes -Wswitch-bool -Wunused-parameter   \
       -Wswitch-enum -Wswitch -Wtrampolines -Wundef -Wuninitialized -Wunsuffixed-float-constants    \
       -Wuseless-cast -Wvector-operation-performance -Wwrite-strings                                \
      "

NLIST="unsafe-buffer-usage c11-extensions extra-semi-stmt gnu-zero-variadic-macro-arguments         \
       pedantic reserved-id-macro invalid-utf8                                                      \
      "

if [ `uname` = 'Linux' ]; then
   make=${MAKE}

   if [ -z "${make}" ]; then
      make=bmake
   fi

   make=`which "${make}"`

   if [ -z "${make}" ]; then
      echo "bmake not found"
      exit 1
   fi

   echo="${ECHO}"

   if [ -z "${echo}" ]; then
      echo=echo
   fi

   cc="${CC}"

   if [ -z "${cc}" ]; then
      cc=cc
   fi

   cc=`which ${cc}`

   if [ -z "${cc}" ]; then
      echo "cc not found"
      exit 1
   fi

   mv="${MV}"

   if [ -z "${mv}" ]; then
      mv=mv
   fi

   mv=`which "${mv}"`

   if [ -z "${mv}" ]; then
      echo "mv not found"
      exit 1
   fi

   rm="${RM}"

   if [ -z "${rm}" ]; then
      rm=rm
   fi

   rm=`which "${rm}"`

   if [ -z "${rm}" ]; then
      echo "rm not found"
      exit 1
   fi

   sed="${SED}"

   if [ -z "${sed}" ]; then
      sed=sed
   fi

   sed=`which "${sed}"`

   if [ -z "${sed}" ]; then
      echo "sed not found"
      exit 1
   fi

   find="${FIND}"

   if [ -z "${find}" ]; then
      find=find
   fi

   find=`which "${find}"`

   if [ -z "${find}" ]; then
      echo "find not found"
      exit 1
   fi

   head="${HEAD}"

   if [ -z "${head}" ]; then
      head=head
   fi

   head=`which "${head}"`

   if [ -z "${head}" ]; then
      echo "head not found"
      exit 1
   fi

   sort="${SORT}"

   if [ -z "${sort}" ]; then
      sort=sort
   fi

   sort=`which "${sort}"`

   if [ -z "${sort}" ]; then
      echo "sort not found"
      exit 1
   fi
else
   m=`make -V MAKE` || :
   make=${MAKE:-${m}}

   if [ -z "${make}" ]; then
      make=make
   fi

   make=`which "${make}"`

   if [ -z "${make}" ]; then
      echo "make not found"
      exit 1
   fi

   echo=`"${make}" -V ECHO`

   if [ -z "${echo}" ]; then
      echo=echo
   fi

   cc=`"${make}" -V CC`

   if [ -z "${cc}" ]; then
      cc=cc
   fi

   cc=`which ${cc}`

   if [ -z "${cc}" ]; then
      echo "cc not found"
      exit 1
   fi

   mv=`"${make}" -V MV`

   if [ -z "${mv}" ]; then
      mv=mv
   fi

   mv=`which "${mv}"`

   if [ -z "${mv}" ]; then
      echo "mv not found"
      exit 1
   fi

   rm=`"${make}" -V RM`

   if [ -z "${rm}" ]; then
      rm=rm
   fi

   rm=`which "${rm}"`

   if [ -z "${rm}" ]; then
      echo "rm not found"
      exit 1
   fi

   sed=`"${make}" -V SED`

   if [ -z "${sed}" ]; then
      sed=sed
   fi

   sed=`which "${sed}"`

   if [ -z "${sed}" ]; then
      echo "sed not found"
      exit 1
   fi

   find=`"${make}" -V FIND`

   if [ -z "${find}" ]; then
      find=find
   fi

   find=`which "${find}"`

   if [ -z "${find}" ]; then
      echo "find not found"
      exit 1
   fi

   head=`"${make}" -V HEAD`

   if [ -z "${head}" ]; then
      head=head
   fi

   head=`which "${head}"`

   if [ -z "${head}" ]; then
      echo "head not found"
      exit 1
   fi

   sort=`"${make}" -V SORT`

   if [ -z "${sort}" ]; then
      sort=sort
   fi

   sort=`which "${sort}"`

   if [ -z "${sort}" ]; then
      echo "sort not found"
      exit 1
fi;fi

"${echo}" "MAKE	= ${make}" >> "${mk}"

f=cctest
${rm} -f "${f}" "${f}.c"
"${echo}" 'int t[] = {-909194803, -185342476};' > "${f}.c"

if ! "${cc}" -pipe -nostdlib -Wl,--oformat=binary,--entry=t -o "${f}" "${f}.c" > /dev/null; then
   NEEDGCC=1
elif ! "${echo}" -n '' | cmp -s /dev/stdin "${f}"; then
   NEEDGCC=1
fi

if [ -n "${NEEDGCC}" ]; then
   path=`"${echo}" ${PATH} | "${sed}" -e 's|:| |g'`
   CCLEXOR=` for i in ${path};                        \
             do "${find}" $i -name 'gcc*'  || true;   \
                "${find}" $i -name 'gcc\*'  || true;  \
             done                                     \
           | "${sed}" -Ene 's|^/.+/(gcc[0-9]*)$|\1|p' \
           | "${sort}" -u                             \
           `
fi

if [ -n "${NEEDGCC}" ]; then
   "${echo}" "NEEDGCC 	?= ${NEEDGCC}" >> "${mk}"
   j=""

   NEEDGCC=""

   for i in ${CCLEXOR}; do
       if "${i}" -pipe -nostdlib -Wl,--oformat=binary,--entry=t -o "${f}" "${f}.c" > /dev/null; then
          if "${echo}" -n '' | cmp -s /dev/stdin "${f}"; then
             if  [ -z "${NEEDGCC}" ]; then
                 NEEDGCC="${i}"
             fi
             j="${j} ${i}"
             "${echo}" "CCLEXOR 	?= ${i}" >> "${mk}"
       fi;fi
   done
fi

"${echo}" 'int main(void) {}' > "${f}.c"
MAXWARNCC=""
MAXWARNLX=""

for i in ${WLIST}; do
    if "${cc}" -pipe -Werror ${MAXWARNCC} "${i}" -o "${f}" "${f}.c" > /dev/null; then
        MAXWARNCC="${MAXWARNCC} ${i}"
    fi
done

for i in ${NLIST}; do
    if "${cc}" -pipe -Werror ${MAXWARNCC} -W"${i}" -o "${f}" "${f}.c" > /dev/null; then
        MAXWARNCC="${MAXWARNCC} -Wno-${i}"
    fi
done

if [ -n "${NEEDGCC}" ]; then
   for i in ${WLIST}; do
       if "${NEEDGCC}" -pipe -Werror ${MAXWARNLX} "${i}" -o "${f}" "${f}.c" > /dev/null; then
           MAXWARNLX="${MAXWARNLX} ${i}"
       fi
   done
   for i in ${NLIST}; do
       if "${NEEDGCC}" -pipe -Werror ${MAXWARNLX} -W"${i}" -o "${f}" "${f}.c" > /dev/null; then
           MAXWARNLX="${MAXWARNLX} -Wno-${i}"
       fi
   done
else
   MAXWARNLX="${MAXWARNCC}"
fi

"${echo}" "MAXWARNCC	+=${MAXWARNCC}" >> "${mk}"
"${echo}" "MAXWARNLX	+=${MAXWARNLX}" >> "${mk}"
"${echo}" '#include <sys/types.h>'                                                 > "${f}.c"
"${echo}" '#include <stddef.h>'                                                   >> "${f}.c"
"${echo}" '#include <stdio.h>'                                                    >> "${f}.c"
"${echo}" 'int main() {'                                                          >> "${f}.c"
"${echo}" '   typedef struct {int8_t a; int16_t b;} B; B b;'                      >> "${f}.c"
"${echo}" '   typedef struct {int8_t a; int32_t c;} C; C c;'                      >> "${f}.c"
"${echo}" '   typedef struct {int8_t a; int64_t d;} D; D d;'                      >> "${f}.c"
"${echo}" '   typedef struct {int8_t a; float   e;} E; E e;'                      >> "${f}.c"
"${echo}" '   typedef struct {int8_t a; double  f;} F; F f;'                      >> "${f}.c"
"${echo}" '   typedef struct {int8_t a; void   *g;} G; G g;'                      >> "${f}.c"
"${echo}" '   printf("CFLAGS	+=");'                                            >> "${f}.c"
"${echo}" '   if  (offsetof(B, b) > 1) printf(" -DBLINAL2=%zu", offsetof(B, b));' >> "${f}.c"
"${echo}" '   if  (offsetof(C, c) > 1) printf(" -DBLINAL4=%zu", offsetof(C, c));' >> "${f}.c"
"${echo}" '   if  (offsetof(D, d) > 1) printf(" -DBLINAL8=%zu", offsetof(D, d));' >> "${f}.c"
"${echo}" '   if  (offsetof(E, e) > 1) printf(" -DBLINAF4=%zu", offsetof(E, e));' >> "${f}.c"
"${echo}" '   if  (offsetof(F, f) > 1) printf(" -DBLINAF8=%zu", offsetof(F, f));' >> "${f}.c"
"${echo}" '   if  (offsetof(G, g) > 1) printf(" -DBLINAP=%zu" , offsetof(G, g));' >> "${f}.c"
"${echo}" '}'                                                                     >> "${f}.c"
"${cc}" -pipe -o "${f}" "${f}.c"
./"${f}" >> "${mk}"
"${echo}" >> "${mk}"

"${echo}" 'void m(int argc);'                                                      > "${f}.c"
"${echo}" 'void m(int argc) {'                                                    >> "${f}.c"
"${echo}" '    switch(argc) {'                                                    >> "${f}.c"
"${echo}" '    case 1: argc++; [[fallthrough]];'                                  >> "${f}.c"
"${echo}" '    case 2: argc++; break;'                                            >> "${f}.c"
"${echo}" '    default: argc++;'                                                  >> "${f}.c"
"${echo}" '}   }'                                                                 >> "${f}.c"

if "${cc}" -pipe -Werror ${MAXWARNCC} -c "${f}.c" > /dev/null; then
    FALLTHROUGH=1
fi

"${echo}" 'void m(int argc);'                                                      > "${f}.c"
"${echo}" 'void m(int argc) {'                                                    >> "${f}.c"
"${echo}" '    switch(argc) {'                                                    >> "${f}.c"
"${echo}" '    case 1: argc++; __attribute__ ((fallthrough));'                    >> "${f}.c"
"${echo}" '    case 2: argc++; break;'                                            >> "${f}.c"
"${echo}" '    default: argc++;'                                                  >> "${f}.c"
"${echo}" '}   }'                                                                 >> "${f}.c"

if "${cc}" -pipe -Werror ${MAXWARNCC} -c "${f}.c" > /dev/null; then
    FALLTHROUGH=2
fi

if [ -n "${FALLTHROUGH}" ]; then
    "${echo}" "CFLAGS	+= -DBLIN_DOFALLTHROUGH=${FALLTHROUGH}" >> "${mk}"
fi

case `uname` in
Linux)
    "${echo}" "CFLAGS	+= -DBLIN_OSLinux"                  >> "${mk}"
    "${echo}" "CFLAGS	+= -I/usr/include/x86_64-linux-gnu" >> "${mk}"
    ;;
esac

${rm} -f "${f}" "${f}.o" "${f}.c"
