/*-
 * Copyright (C)2020..2025 @BABOLO http://www.babolo.ru/
 * PKG = babolo-libmake
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2020..2025 @BABOLO http://www.babolo.ru/"
#ident "@(#) $Id: utils.c,v 1.16 2025/04/22 03:13:40 babolo Exp $"

#define Bpars_COMPAT  4
#define MULAR_COMPAT  0
#define MIFE_COMPAT   5
#define BLIN_COMPAT   VMAJOR
#define BLIN_INTERNAL

#include <sys/types.h>
#include <sys/event.h>
#include <sys/file.h>
#include <sysexits.h>
#include <string.h>
#include <stdlib.h>
#include <stdarg.h>
#include <stddef.h>
#include <limits.h>
#include <unistd.h>
#include <stdio.h>
#include <errno.h>
#include <time.h>
#include <err.h>
#include "../BLINflag.h"
#include <babolo/parser.h>
#include <multilar.h>
#include <mife.h>
#include "blinread.h"

static u_int64_t
pow_10(int8_t num) {
    u_int64_t ret;
    for (ret = 1; num > 0; num--) ret *= 10;
    return(ret);
}

// sec[.nsec][-sec[.nsec]]
int
timerel2i(BLINr_cfg *cfg, BLINr_time *time, const char *optargs) {
#   define blin_internal_flags (cfg->flags & BLIN_MASK)
    const char *mem;
    u_int64_t   tmp;
    int         ex = EX_OK;           /*                            */
    char       *p  ;

    time->nrng = 1;
    time->to = 0;
    time->abs = 0;
    time->from = strtoul(optargs, &p, 10) * BLINr_E9;
    if  (*p == '.') {
        mem = ++p;
        tmp = strtoul(p, &p, 10);
        time->from += tmp * pow_10((int8_t)(9 - (p - mem)));
    }
    if  (*p == '-') {
        time->nrng = 0;
        p++;
        time->to = strtoul(p, &p, 10) * BLINr_E9;
        if  (*p == '.') {
            mem = ++p;
            tmp = strtoul(p, &p, 10);
            time->to += tmp * pow_10((int8_t)(9 - (p - mem)));
        } else if(*p != '\0') {
            ifBLIN_QX0("bad syntax");
            ex = EX_USAGE;
            goto out;
        }
    } else if(*p != '\0') {
        ifBLIN_QX0("bad syntax");
        ex = EX_USAGE;
        goto out;
    }
out:
    return(ex);
#   undef blin_internal_flags
}

// DATE[-DATE]
// DATE is YYYY-MM-DD[_hh:mm:ss[.nsec]]
int
timeabs2i(BLINr_cfg *cfg, BLINr_time *time, const char *optargs) {
#   define blin_internal_flags (cfg->flags & BLIN_MASK)
    const char *mem;
    struct tm   stime1;               /*      ISO */
    struct tm   stime2;               /*      ISO */
    int         ex = EX_OK;           /*                            */
    char       *p;
    u_int64_t   tmp;

    stime1.tm_zone = NULL;
    stime1.tm_hour = 0;
    stime1.tm_min = 0;
    stime1.tm_sec = 0;
    time->nrng = 1;
    time->abs = 1;
    time->from = 0;
    time->to = 0;
    stime1.tm_year = (int)strtoul(optargs, &p, 10) - 1900;
    if  (*p != '-') {
        ifBLIN_QX0("bad syntax");
        ex = EX_USAGE;
        goto out;
    }
    p++;
    stime1.tm_mon  = (int)strtoul(p, &p, 10) - 1;
    if  (*p != '-') {
        ifBLIN_QX0("bad syntax");
        ex = EX_USAGE;
        goto out;
    }
    p++;
    stime1.tm_mday = (int)strtoul(p, &p, 10);
    if  (*p == '_') {
        p++;
        stime1.tm_hour = (int)strtoul(p, &p, 10);
        if  (*p != ':') {
            ifBLIN_QX0("bad syntax");
            ex = EX_USAGE;
            goto out;
        }
        p++;
        stime1.tm_min  = (int)strtoul(p, &p, 10);
        if  (*p != ':') {
            ifBLIN_QX0("bad syntax");
            ex = EX_USAGE;
            goto out;
        }
        p++;
        stime1.tm_sec  = (int)strtoul(p, &p, 10);
        if  (*p == '.') {
            mem = ++p;
            tmp = strtoul(p, &p, 10);
            time->from = tmp * pow_10((int8_t)(9 - (p - mem)));
    }   }
    time->from += (unsigned long)mktime(&stime1) * BLINr_E9;
    if  (*p == '-') {
        time->nrng = 0;
        time->to = 0;
        stime2.tm_zone = NULL;
        stime2.tm_hour = 0;
        stime2.tm_min = 0;
        stime2.tm_sec = 0;
        p++;
        stime2.tm_year = (int)strtoul(p, &p, 10) - 1900;
        if  (*p != '-') {
            ifBLIN_QX0("bad syntax");
            ex = EX_USAGE;
            goto out;
        }
        p++;
        stime2.tm_mon  = (int)strtoul(p, &p, 10) - 1;
        if  (*p != '-') {
            ifBLIN_QX0("bad syntax");
            ex = EX_USAGE;
            goto out;
        }
        p++;
        stime2.tm_mday = (int)strtoul(p, &p, 10);
        if  (*p == '_') {
            p++;
            stime2.tm_hour = (int)strtoul(p, &p, 10);
            if  (*p != ':') {
                ifBLIN_QX0("bad syntax");
                ex = EX_USAGE;
                goto out;
            }
            p++;
            stime2.tm_min  = (int)strtoul(p, &p, 10);
            if  (*p != ':') {
                ifBLIN_QX0("bad syntax");
                ex = EX_USAGE;
                goto out;
            }
            p++;
            stime2.tm_sec  = (int)strtoul(p, &p, 10);
            if  (*p == '.') {
                mem = ++p;
                tmp = strtoul(p, &p, 10);
                time->to = tmp * pow_10((int8_t)(9 - (p - mem)));
        }   }
        time->to += (unsigned long)mktime(&stime2) * BLINr_E9;
    }
    if  (*p != '\0') {
        ifBLIN_QX0("bad syntax");
        ex = EX_USAGE;
        goto out;
    }
out:
    return(ex);
#   undef blin_internal_flags
}

BLIN_trace *
BLINr_next_wind(BLINr_cfg *cfg) {
#   define blin_internal_flags (cfg->flags & BLIN_MASK)
    off_t       offset;           /*                */
    BLIN_trace *twind;            /*   tracfile                 */
    u_int32_t   windsize;         /*     tracfile */
    ssize_t     chunksz;

    if  (!(twind = mife_pointer(cfg->tfile))) {
        if  (!(twind = mife_window(cfg->tfile, 0, sizeof(windsize)))) {
            ifBLIN_QW0("mife_window");
            twind = NULL;
            goto out;
        }
        if  (0 > (chunksz = mife_ctlsize(cfg->tfile))) {
            ifBLIN_QW0("mife_ctlsize");
            twind = NULL;
            goto out;
        }
        if  ((size_t)chunksz < sizeof(windsize)) {
            ifBLIN_QX0("less than len_t %lu", sizeof(windsize));
            twind = NULL;
            goto out;
        }
        windsize = twind->len;
        if  (!(twind = mife_window(cfg->tfile, 0, (ssize_t)(windsize + sizeof(windsize))))) {
            ifBLIN_QW0("mife_window");
            twind = NULL;
            goto out;
        }
        ifBLIN_QX5("%"BLIN_X"[%zd]%u", BLIN_I(twind), mife_ctlsize(cfg->tfile), windsize);
        if  (mife_ctlsize(cfg->tfile) < (ssize_t)windsize) {
            ifBLIN_QX0("less than asked %u", windsize);
            twind = NULL;
            goto out;
        }
    } else {
        if  (0 > (chunksz = mife_ctlsize(cfg->tfile))) {
            ifBLIN_QW0("mife_ctlsize");
            twind = NULL;
            goto out;
        }
        if  ((size_t)chunksz < sizeof(windsize)) { // redundant? check
            ifBLIN_QX0("less than len_t %lu", sizeof(windsize));
            twind = NULL;
            goto out;
        }
        windsize = twind->len;
        offset = cfg->tfile->ofpoint + windsize;
        ifBLIN_QX5("%"BLIN_X"[%zd]%u", BLIN_I(twind), chunksz, windsize);
        if  ((size_t)chunksz < (windsize + sizeof(windsize))) {
            twind = NULL;
            goto out;
        }
        twind = (BLIN_trace *)((char*)twind + windsize); // undefined if windsize not aligned for len_t
        ifBLIN_QX5("%"BLIN_X, BLIN_I(twind));
        windsize = twind->len;
        if  (!(twind = mife_window(cfg->tfile, offset, (ssize_t)(windsize + sizeof(windsize))))) {
            ifBLIN_QW0("mife_window");
            twind = NULL;
            goto out;
        }
        ifBLIN_QX5("%"BLIN_X"[%zd]%u", BLIN_I(twind), mife_ctlsize(cfg->tfile), windsize);
        if  (mife_ctlsize(cfg->tfile) < (ssize_t)windsize) {
            ifBLIN_QX0("less than asked %u", windsize);
            twind = NULL;
            goto out;
        }
    }
out:
    return(twind);
#   undef blin_internal_flags
}
