# Copyright (C)2006..2024 @BABOLO http://www.babolo.ru/
# pkg = babolo-libmake
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#
# $Id: subdir.make,v 1.19 2024/06/16 12:26:16 babolo Exp $

SUBDIR	+= ${NXTDIR} ${MODULE}
.include <${PREFIX}/include/babolo/define.make>

all:
.for I in ${SUBDIR}
. if exists(${I}/Makefile)
	@echo ================== ${I} ==================
	@(cd ${I}; ${MAKE} ${MAKEFLAGS} all)
. endif
.endfor

findiff:
	@ subdir.pgoblin
.for I in ${NXTDIR}
	@echo ================== ${I} ==================
	@(cd ${I}; ${MAKE} findiff)
.endfor

ignore:
	@-make -V IGNORE | tr ' ' '\n' | grep -v '^CVS$$'
.for I in ${NXTDIR}
	@echo ================== ${I} ==================
	@(cd ${I}; ${MAKE} ignore)
.endfor

clean:
.for I in ${SUBDIR}
. if exists(${I}/Makefile)
	@echo ================== ${I} ==================
	@(cd ${I}; ${MAKE} ${MAKEFLAGS} clean)
. endif
.endfor

cleacvs:
	@for i in .#*.*[0-9].*[0-9];                   \
         do if [ -f $${i} ];                           \
            then ${ECHO} ${PWD}/$${i}; ${RM} -f $${i}; \
            fi                                         \
         done
.for I in ${SUBDIR}
. if exists(${I}/Makefile)
	@echo ================== ${I} ==================
	@(cd ${I}; ${MAKE} ${MAKEFLAGS} cleacvs)
. else
	@for i in ${I}/.#*.*[0-9].*[0-9]               \
                  ${I}/*/.#*.*[0-9].*[0-9]             \
                  ${I}/*/*/.#*.*[0-9].*[0-9]           \
                  ${I}/*/*/*/.#*.*[0-9].*[0-9]         \
                  ${I}/*/*/*/*/.#*.*[0-9].*[0-9]       \
                  ${I}/*/*/*/*/*/.#*.*[0-9].*[0-9];    \
         do if [ -f $${i} ];                           \
            then ${ECHO} ${PWD}/$${i}; ${RM} -f $${i}; \
            fi                                         \
         done
. endif
.endfor

tarball:
.for I in ${SUBDIR}
. if exists(${I}/Makefile)
	@echo ================== ${I} ==================
	@(cd ${I}; ${MAKE} ${MAKEFLAGS} tarball)
. endif
.endfor

install:
.for I in ${SUBDIR}
. if exists(${I}/Makefile)
	@echo ================== ${I} ==================
	@(cd ${I}; ${MAKE} ${MAKEFLAGS} install)
. endif
.endfor

gitup:
.for I in ${NXTDIR}
	@echo ================== ${I} ==================
	@(cd ${I}; ${MAKE} ${MAKEFLAGS} GITUP=${GITUP} gitup)
.endfor
.for I in ${MODULE}
. if exists(${I}/Makefile)
	@(cd ${I}; ${MAKE} ${MAKEFLAGS} GITUP=${GITUP} gitup)
. elif exists(${I}/.git)
	(cd ${I}; git fetch)
.  if ("${GITUP}" == "")
	(cd ${I}; git checkout -f master)
	(cd ${I}; git merge --ff --overwrite-ignore FETCH_HEAD)
.  else
.   for J in ${GITUP}
	(cd ${I}; git checkout -f ${J})
	(cd ${I}; git merge --ff --overwrite-ignore FETCH_HEAD)
.   endfor
.  endif
. endif
.endfor

version:
.for I in ${MODULE}
. if exists(${I}/Makefile)
	@if [ -n "`cd ${I}; ${MAKE} -V PKG`" ] ; then                                       \
            (cd ${I}; ${ECHO} "`${MAKE} -V VMAJOR`.`${MAKE} -V VMINOR`	`${MAKE} -V PKG`"); \
         else                                                                               \
            ${ECHO} "	${I}";                                                              \
         fi
. else
	${ECHO} "	${I}"
. endif
.endfor
.for I in ${NXTDIR}
	@(cd ${I}; ${MAKE} version)
.endfor

todo:
.for I in ${SUBDIR}
. if exists(${I}/Makefile)
	@(cd ${I}; ${MAKE} ${MAKEFLAGS} todo)
. endif
.endfor
