/*-
 * Copyright (C)2003..2025 @BABOLO http://www.babolo.ru/
 * PKG = babolo-libmake
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: BLINflag.h,v 1.94 2025/12/21 18:10:58 babolo Exp $
 */

#ifndef  _BABOLO_BLINflag_H_
# define _BABOLO_BLINflag_H_

__BEGIN_DECLS

# if !defined(_SYS_TYPES_H_) && !defined(_SYS_TYPES_H)
#  warning this file needs sys/types.h as a prerequisite
#  include <sys/types.h>
# endif

# if !defined(_STDIO_H_) && !defined(_STDIO_H)
#  warning this file needs stdio.h as a prerequisite
#  include <stdio.h>
# endif

# ifndef BLIN_COMPAT
#  warning BLIN_COMPAT not defined
# endif

#ifndef __printflike
# define __printflike(FORMATARG, F_VARARG) __attribute__((format (printf, FORMATARG, F_VARARG)))
#endif

#ifndef BLIN_DOFALLTHROUGH
# define BLIN_FALLTHROUGH
#elif BLIN_DOFALLTHROUGH == 1
# define BLIN_FALLTHROUGH [[fallthrough]]
#elif BLIN_DOFALLTHROUGH >= 2
# define BLIN_FALLTHROUGH __attribute__ ((fallthrough))
#else
# define BLIN_FALLTHROUGH
#endif

# define ifBLIN_FLAG  BLIN_flag blin_internal_flags
# define BLIN_flags   blin_internal_flags
# define BLIN_DOCRY   0x010000
# define BLIN_DOTRACE (((blin_pamparam *)&blin_direct_flags)->tracfile >= 0)

# if defined(BLIN_COMPAT2) || (defined(BLIN_COMPAT) && (BLIN_COMPAT <= 2))
/*****************************************************************************************************/
                                    /*   old style points of debugging. have to be deleted sometimes */
#  define ifBLIN_QV1(FL) if ((FL) & BLIN_BIT0)
#  define ifBLIN_QV2(FL) if ((FL) & BLIN_BIT1)
#  define ifBLIN_QV3(FL) if ((FL) & BLIN_BIT2)
#  define ifBLIN_QV4(FL) if ((FL) & BLIN_BIT3)
#  define ifBLIN_QV5(FL) if ((FL) & BLIN_BIT4)
#  define ifBLIN_QV6(FL) if ((FL) & BLIN_BIT5)
#  define ifBLIN_QV7(FL) if ((FL) & BLIN_BIT6)
#  define ifBLIN_QV8(FL) if ((FL) & BLIN_BIT7)

# endif /* BLIN_COMPAT2 */

/*****************************************************************************************************/
                                     /*                                 new style poins of debugging */

/*****************************************************************************************************/
                                                      /* XXXX */
# if defined(BLIN_COMPAT) && (BLIN_COMPAT <= 3)
#  define BLIN_DU_TEXT BLIN_MODDTXT                                      /* text right on bytes      */

#  define ifBLIN_TEMPLATE(L, F, ...)                                                                  \
     blin_cry1((L), "%s:%s:%d: " F, __FILE__, __func__, __LINE__, ## __VA_ARGS__)

#  define ifBLIN_TPL(L, F, ...)                                                                       \
     blin_cry1((L), "%s:%s:%d: " F, __FILE__, __func__, __LINE__, ## __VA_ARGS__)

#  define ifBLIN_NOW(L, F, ...)                                                                       \
     blin_cry1((L), "%s:%s:%d: " F, __FILE__, __func__, __LINE__, ## __VA_ARGS__)

#  define ifBLIN_QQ0(FL) if ((FL) & BLIN_BIT0)
#  define ifBLIN_QQ1(FL) if ((FL) & BLIN_BIT1)
#  define ifBLIN_QQ2(FL) if ((FL) & BLIN_BIT2)
#  define ifBLIN_QQ3(FL) if ((FL) & BLIN_BIT3)
#  define ifBLIN_QQ4(FL) if ((FL) & BLIN_BIT4)
#  define ifBLIN_QQ5(FL) if ((FL) & BLIN_BIT5)
#  define ifBLIN_QQ6(FL) if ((FL) & BLIN_BIT6)
#  define ifBLIN_QQ7(FL) if ((FL) & BLIN_BIT7)

#  define ifBLIN_QO0 if ((blin_internal_flags) & BLIN_BIT0)
#  define ifBLIN_QO1 if ((blin_internal_flags) & BLIN_BIT1)
#  define ifBLIN_QO2 if ((blin_internal_flags) & BLIN_BIT2)
#  define ifBLIN_QO3 if ((blin_internal_flags) & BLIN_BIT3)
#  define ifBLIN_QO4 if ((blin_internal_flags) & BLIN_BIT4)
#  define ifBLIN_QO5 if ((blin_internal_flags) & BLIN_BIT5)
#  define ifBLIN_QO6 if ((blin_internal_flags) & BLIN_BIT6)
#  define ifBLIN_QO7 if ((blin_internal_flags) & BLIN_BIT7)

#  define ifBLIN_QU0(FL, F, ...) ifBLIN_QQ0(FL) ifBLIN_TPL(0, F, ## __VA_ARGS__)
#  define ifBLIN_QU1(FL, F, ...) ifBLIN_QQ1(FL) ifBLIN_TPL(1, F, ## __VA_ARGS__)
#  define ifBLIN_QU2(FL, F, ...) ifBLIN_QQ2(FL) ifBLIN_TPL(2, F, ## __VA_ARGS__)
#  define ifBLIN_QU3(FL, F, ...) ifBLIN_QQ3(FL) ifBLIN_TPL(3, F, ## __VA_ARGS__)
#  define ifBLIN_QU4(FL, F, ...) ifBLIN_QQ4(FL) ifBLIN_TPL(4, F, ## __VA_ARGS__)
#  define ifBLIN_QU5(FL, F, ...) ifBLIN_QQ5(FL) ifBLIN_TPL(5, F, ## __VA_ARGS__)
#  define ifBLIN_QU6(FL, F, ...) ifBLIN_QQ6(FL) ifBLIN_TPL(6, F, ## __VA_ARGS__)
#  define ifBLIN_QU7(FL, F, ...) ifBLIN_QQ7(FL) ifBLIN_TPL(7, F, ## __VA_ARGS__)

#  define ifBLIN_QX0(F, ...) ifBLIN_QO0 ifBLIN_TPL( 0, F, ## __VA_ARGS__)
#  define ifBLIN_QX1(F, ...) ifBLIN_QO1 ifBLIN_TPL( 1, F, ## __VA_ARGS__)
#  define ifBLIN_QX2(F, ...) ifBLIN_QO2 ifBLIN_TPL( 2, F, ## __VA_ARGS__)
#  define ifBLIN_QX3(F, ...) ifBLIN_QO3 ifBLIN_TPL( 3, F, ## __VA_ARGS__)
#  define ifBLIN_QX4(F, ...) ifBLIN_QO4 ifBLIN_TPL( 4, F, ## __VA_ARGS__)
#  define ifBLIN_QX5(F, ...) ifBLIN_QO5 ifBLIN_TPL( 5, F, ## __VA_ARGS__)
#  define ifBLIN_QX6(F, ...) ifBLIN_QO6 ifBLIN_TPL( 6, F, ## __VA_ARGS__)
#  define ifBLIN_QX7(F, ...) ifBLIN_QO7 ifBLIN_TPL( 7, F, ## __VA_ARGS__)

#  define ifBLIN_QW0(F, ...) ifBLIN_QO0 ifBLIN_TPL( 8, F, ## __VA_ARGS__)
#  define ifBLIN_QW1(F, ...) ifBLIN_QO1 ifBLIN_TPL( 9, F, ## __VA_ARGS__)
#  define ifBLIN_QW2(F, ...) ifBLIN_QO2 ifBLIN_TPL(10, F, ## __VA_ARGS__)
#  define ifBLIN_QW3(F, ...) ifBLIN_QO3 ifBLIN_TPL(11, F, ## __VA_ARGS__)
#  define ifBLIN_QW4(F, ...) ifBLIN_QO4 ifBLIN_TPL(12, F, ## __VA_ARGS__)
#  define ifBLIN_QW5(F, ...) ifBLIN_QO5 ifBLIN_TPL(13, F, ## __VA_ARGS__)
#  define ifBLIN_QW6(F, ...) ifBLIN_QO6 ifBLIN_TPL(14, F, ## __VA_ARGS__)
#  define ifBLIN_QW7(F, ...) ifBLIN_QO7 ifBLIN_TPL(15, F, ## __VA_ARGS__)

#  define ifBLIN_QZ0(F, ...) ifBLIN_NOW( 0, F, ## __VA_ARGS__)
#  define ifBLIN_QZ1(F, ...) ifBLIN_NOW( 1, F, ## __VA_ARGS__)
#  define ifBLIN_QZ2(F, ...) ifBLIN_NOW( 2, F, ## __VA_ARGS__)
#  define ifBLIN_QZ3(F, ...) ifBLIN_NOW( 3, F, ## __VA_ARGS__)
#  define ifBLIN_QZ4(F, ...) ifBLIN_NOW( 4, F, ## __VA_ARGS__)
#  define ifBLIN_QZ5(F, ...) ifBLIN_NOW( 5, F, ## __VA_ARGS__)
#  define ifBLIN_QZ6(F, ...) ifBLIN_NOW( 6, F, ## __VA_ARGS__)
#  define ifBLIN_QZ7(F, ...) ifBLIN_NOW( 7, F, ## __VA_ARGS__)

#  define ifBLIN_QY0(F, ...) ifBLIN_NOW( 8, F, ## __VA_ARGS__)
#  define ifBLIN_QY1(F, ...) ifBLIN_NOW( 9, F, ## __VA_ARGS__)
#  define ifBLIN_QY2(F, ...) ifBLIN_NOW(10, F, ## __VA_ARGS__)
#  define ifBLIN_QY3(F, ...) ifBLIN_NOW(11, F, ## __VA_ARGS__)
#  define ifBLIN_QY4(F, ...) ifBLIN_NOW(12, F, ## __VA_ARGS__)
#  define ifBLIN_QY5(F, ...) ifBLIN_NOW(13, F, ## __VA_ARGS__)
#  define ifBLIN_QY6(F, ...) ifBLIN_NOW(14, F, ## __VA_ARGS__)
#  define ifBLIN_QY7(F, ...) ifBLIN_NOW(15, F, ## __VA_ARGS__)

# else

#  define ifBLIN_TEMPLATE(FL, L, F, ...)                                                              \
     blin_cry4((L) | ((FL) ? BLIN_DOCRY : 0), __FILE__, __func__, __LINE__, F, ## __VA_ARGS__)

#  define ifBLIN_TPL(FL, L, F, ...)                                                                   \
     blin_cry4((L) | ((FL) ? BLIN_DOCRY : 0), __FILE__, __func__, __LINE__, F, ## __VA_ARGS__)

#  define ifBLIN_NOW(L, F, ...)                                                                       \
     blin_cry4((L) | BLIN_DOCRY, __FILE__, __func__, __LINE__, F, ## __VA_ARGS__)

#  if !defined(BLIN_NON) || (BLIN_NON > 0)

#   define ifBLIN_QN0(BLIN)       BLIN
#   define ifBLIN_QQ0(FL)         if (BLIN_DOTRACE || ((FL) & BLIN_BIT0))
#   define ifBLIN_QO0             if (BLIN_DOTRACE || ((blin_internal_flags) & BLIN_BIT0))
#   define ifBLIN_QU0(FL, F, ...) ifBLIN_TPL((FL) & BLIN_BIT0, 0, F, ## __VA_ARGS__)
#   define ifBLIN_QX0(    F, ...) ifBLIN_TPL((blin_internal_flags) & BLIN_BIT0,  0, F, ## __VA_ARGS__)
#   define ifBLIN_QW0(    F, ...) ifBLIN_TPL((blin_internal_flags) & BLIN_BIT0,  8, F, ## __VA_ARGS__)
#   define ifBLIN_QZ0(    F, ...) ifBLIN_NOW( 0, F, ## __VA_ARGS__)
#   define ifBLIN_QY0(    F, ...) ifBLIN_NOW( 8, F, ## __VA_ARGS__)

#  else

#   define ifBLIN_QN0(BLIN)
#   define ifBLIN_QQ0(FL)         if (0)
#   define ifBLIN_QO0             if (0)
#   define ifBLIN_QU0(FL, F, ...)
#   define ifBLIN_QX0(    F, ...)
#   define ifBLIN_QW0(    F, ...)
#   define ifBLIN_QZ0(    F, ...)
#   define ifBLIN_QY0(    F, ...)

#  endif

#  if !defined(BLIN_NON) || (BLIN_NON > 1)

#   define ifBLIN_QN1(BLIN)       BLIN
#   define ifBLIN_QQ1(FL)         if (BLIN_DOTRACE || ((FL) & BLIN_BIT1))
#   define ifBLIN_QO1             if (BLIN_DOTRACE || ((blin_internal_flags) & BLIN_BIT1))
#   define ifBLIN_QU1(FL, F, ...) ifBLIN_TPL((FL) & BLIN_BIT1, 1, F, ## __VA_ARGS__)
#   define ifBLIN_QX1(    F, ...) ifBLIN_TPL((blin_internal_flags) & BLIN_BIT1,  1, F, ## __VA_ARGS__)
#   define ifBLIN_QW1(    F, ...) ifBLIN_TPL((blin_internal_flags) & BLIN_BIT1,  9, F, ## __VA_ARGS__)
#   define ifBLIN_QZ1(    F, ...) ifBLIN_NOW( 1, F, ## __VA_ARGS__)
#   define ifBLIN_QY1(    F, ...) ifBLIN_NOW( 9, F, ## __VA_ARGS__)

#  else

#   define ifBLIN_QN1(BLIN)
#   define ifBLIN_QQ1(FL)         if (0)
#   define ifBLIN_QO1             if (0)
#   define ifBLIN_QU1(FL, F, ...)
#   define ifBLIN_QX1(    F, ...)
#   define ifBLIN_QW1(    F, ...)
#   define ifBLIN_QZ1(    F, ...)
#   define ifBLIN_QY1(    F, ...)

#  endif

#  if !defined(BLIN_NON) || (BLIN_NON > 2)

#   define ifBLIN_QN2(BLIN)       BLIN
#   define ifBLIN_QQ2(FL)         if (BLIN_DOTRACE || ((FL) & BLIN_BIT2))
#   define ifBLIN_QO2             if (BLIN_DOTRACE || ((blin_internal_flags) & BLIN_BIT2))
#   define ifBLIN_QU2(FL, F, ...) ifBLIN_TPL((FL) & BLIN_BIT2, 2, F, ## __VA_ARGS__)
#   define ifBLIN_QX2(    F, ...) ifBLIN_TPL((blin_internal_flags) & BLIN_BIT2,  2, F, ## __VA_ARGS__)
#   define ifBLIN_QW2(    F, ...) ifBLIN_TPL((blin_internal_flags) & BLIN_BIT2, 10, F, ## __VA_ARGS__)
#   define ifBLIN_QZ2(    F, ...) ifBLIN_NOW( 2, F, ## __VA_ARGS__)
#   define ifBLIN_QY2(    F, ...) ifBLIN_NOW(10, F, ## __VA_ARGS__)

#  else

#   define ifBLIN_QN2(BLIN)
#   define ifBLIN_QQ2(FL)         if (0)
#   define ifBLIN_QO2             if (0)
#   define ifBLIN_QU2(FL, F, ...)
#   define ifBLIN_QX2(    F, ...)
#   define ifBLIN_QW2(    F, ...)
#   define ifBLIN_QZ2(    F, ...)
#   define ifBLIN_QY2(    F, ...)

#  endif

#  if !defined(BLIN_NON) || (BLIN_NON > 3)

#   define ifBLIN_QN3(BLIN)       BLIN
#   define ifBLIN_QQ3(FL)         if (BLIN_DOTRACE || ((FL) & BLIN_BIT3))
#   define ifBLIN_QO3             if (BLIN_DOTRACE || ((blin_internal_flags) & BLIN_BIT3))
#   define ifBLIN_QU3(FL, F, ...) ifBLIN_TPL((FL) & BLIN_BIT3, 3, F, ## __VA_ARGS__)
#   define ifBLIN_QX3(    F, ...) ifBLIN_TPL((blin_internal_flags) & BLIN_BIT3,  3, F, ## __VA_ARGS__)
#   define ifBLIN_QW3(    F, ...) ifBLIN_TPL((blin_internal_flags) & BLIN_BIT3, 11, F, ## __VA_ARGS__)
#   define ifBLIN_QZ3(    F, ...) ifBLIN_NOW( 3, F, ## __VA_ARGS__)
#   define ifBLIN_QY3(    F, ...) ifBLIN_NOW(11, F, ## __VA_ARGS__)

#  else

#   define ifBLIN_QN3(BLIN)
#   define ifBLIN_QQ3(FL)         if (0)
#   define ifBLIN_QO3             if (0)
#   define ifBLIN_QU3(FL, F, ...)
#   define ifBLIN_QX3(    F, ...)
#   define ifBLIN_QW3(    F, ...)
#   define ifBLIN_QZ3(    F, ...)
#   define ifBLIN_QY3(    F, ...)

#  endif

#  if !defined(BLIN_NON) || (BLIN_NON > 4)

#   define ifBLIN_QN4(BLIN)       BLIN
#   define ifBLIN_QQ4(FL)         if (BLIN_DOTRACE || ((FL) & BLIN_BIT4))
#   define ifBLIN_QO4             if (BLIN_DOTRACE || ((blin_internal_flags) & BLIN_BIT4))
#   define ifBLIN_QU4(FL, F, ...) ifBLIN_TPL((FL) & BLIN_BIT4, 4, F, ## __VA_ARGS__)
#   define ifBLIN_QX4(    F, ...) ifBLIN_TPL((blin_internal_flags) & BLIN_BIT4,  4, F, ## __VA_ARGS__)
#   define ifBLIN_QW4(    F, ...) ifBLIN_TPL((blin_internal_flags) & BLIN_BIT4, 12, F, ## __VA_ARGS__)
#   define ifBLIN_QZ4(    F, ...) ifBLIN_NOW( 4, F, ## __VA_ARGS__)
#   define ifBLIN_QY4(    F, ...) ifBLIN_NOW(12, F, ## __VA_ARGS__)

#  else

#   define ifBLIN_QN4(BLIN)
#   define ifBLIN_QQ4(FL)         if (0)
#   define ifBLIN_QO4             if (0)
#   define ifBLIN_QU4(FL, F, ...)
#   define ifBLIN_QX4(    F, ...)
#   define ifBLIN_QW4(    F, ...)
#   define ifBLIN_QZ4(    F, ...)
#   define ifBLIN_QY4(    F, ...)

#  endif

#  if !defined(BLIN_NON) || (BLIN_NON > 5)

#   define ifBLIN_QN5(BLIN)       BLIN
#   define ifBLIN_QQ5(FL)         if (BLIN_DOTRACE || ((FL) & BLIN_BIT5))
#   define ifBLIN_QO5             if (BLIN_DOTRACE || ((blin_internal_flags) & BLIN_BIT5))
#   define ifBLIN_QU5(FL, F, ...) ifBLIN_TPL((FL) & BLIN_BIT5, 5, F, ## __VA_ARGS__)
#   define ifBLIN_QX5(    F, ...) ifBLIN_TPL((blin_internal_flags) & BLIN_BIT5,  5, F, ## __VA_ARGS__)
#   define ifBLIN_QW5(    F, ...) ifBLIN_TPL((blin_internal_flags) & BLIN_BIT5, 13, F, ## __VA_ARGS__)
#   define ifBLIN_QZ5(    F, ...) ifBLIN_NOW( 5, F, ## __VA_ARGS__)
#   define ifBLIN_QY5(    F, ...) ifBLIN_NOW(13, F, ## __VA_ARGS__)

#  else

#   define ifBLIN_QN5(BLIN)
#   define ifBLIN_QQ5(FL)         if (0)
#   define ifBLIN_QO5             if (0)
#   define ifBLIN_QU5(FL, F, ...)
#   define ifBLIN_QX5(    F, ...)
#   define ifBLIN_QW5(    F, ...)
#   define ifBLIN_QZ5(    F, ...)
#   define ifBLIN_QY5(    F, ...)

#  endif

#  if !defined(BLIN_NON) || (BLIN_NON > 6)

#   define ifBLIN_QN6(BLIN)       BLIN
#   define ifBLIN_QQ6(FL)         if (BLIN_DOTRACE || ((FL) & BLIN_BIT6))
#   define ifBLIN_QO6             if (BLIN_DOTRACE || ((blin_internal_flags) & BLIN_BIT6))
#   define ifBLIN_QU6(FL, F, ...) ifBLIN_TPL((FL) & BLIN_BIT6, 6, F, ## __VA_ARGS__)
#   define ifBLIN_QX6(    F, ...) ifBLIN_TPL((blin_internal_flags) & BLIN_BIT6,  6, F, ## __VA_ARGS__)
#   define ifBLIN_QW6(    F, ...) ifBLIN_TPL((blin_internal_flags) & BLIN_BIT6, 14, F, ## __VA_ARGS__)
#   define ifBLIN_QZ6(    F, ...) ifBLIN_NOW( 6, F, ## __VA_ARGS__)
#   define ifBLIN_QY6(    F, ...) ifBLIN_NOW(14, F, ## __VA_ARGS__)

#  else

#   define ifBLIN_QN6(BLIN)
#   define ifBLIN_QQ6(FL)         if (0)
#   define ifBLIN_QO6             if (0)
#   define ifBLIN_QU6(FL, F, ...)
#   define ifBLIN_QX6(    F, ...)
#   define ifBLIN_QW6(    F, ...)
#   define ifBLIN_QZ6(    F, ...)
#   define ifBLIN_QY6(    F, ...)

#  endif

#  if !defined(BLIN_NON) || (BLIN_NON > 7)

#   define ifBLIN_QN7(BLIN)       BLIN
#   define ifBLIN_QQ7(FL)         if (BLIN_DOTRACE || ((FL) & BLIN_BIT7))
#   define ifBLIN_QO7             if (BLIN_DOTRACE || ((blin_internal_flags) & BLIN_BIT7))
#   define ifBLIN_QU7(FL, F, ...) ifBLIN_TPL((FL) & BLIN_BIT7, 7, F, ## __VA_ARGS__)
#   define ifBLIN_QX7(    F, ...) ifBLIN_TPL((blin_internal_flags) & BLIN_BIT7,  7, F, ## __VA_ARGS__)
#   define ifBLIN_QW7(    F, ...) ifBLIN_TPL((blin_internal_flags) & BLIN_BIT7, 15, F, ## __VA_ARGS__)
#   define ifBLIN_QZ7(    F, ...) ifBLIN_NOW( 7, F, ## __VA_ARGS__)
#   define ifBLIN_QY7(    F, ...) ifBLIN_NOW(15, F, ## __VA_ARGS__)

#  else

#   define ifBLIN_QN7(BLIN)
#   define ifBLIN_QQ7(FL)         if (0)
#   define ifBLIN_QO7             if (0)
#   define ifBLIN_QU7(FL, F, ...)
#   define ifBLIN_QX7(    F, ...)
#   define ifBLIN_QW7(    F, ...)
#   define ifBLIN_QZ7(    F, ...)
#   define ifBLIN_QY7(    F, ...)

#  endif
# endif

typedef u_int32_t BLIN_flag;

/*****************************************************************************************************/
/*                                                                               BLIN infrastructure */
typedef struct blin_pamparam {
    BLIN_flag flags;                 /*                   0    */
/*                                                                    for use in points of debugging */
# define BLIN_BIT0    0x01000000
# define BLIN_BIT1    0x02000000
# define BLIN_BIT2    0x04000000
# define BLIN_BIT3    0x08000000
# define BLIN_BIT4    0x10000000
# define BLIN_BIT5    0x20000000
# define BLIN_BIT6    0x40000000
# define BLIN_BIT7    0x80000000
# define BLIN_GEN0    BLIN_BIT0
# define BLIN_GEN1    (BLIN_GEN0 | BLIN_BIT1)
# define BLIN_GEN2    (BLIN_GEN1 | BLIN_BIT2)
# define BLIN_GEN3    (BLIN_GEN2 | BLIN_BIT3)
# define BLIN_GEN4    (BLIN_GEN3 | BLIN_BIT4)
# define BLIN_GEN5    (BLIN_GEN4 | BLIN_BIT5)
# define BLIN_GEN6    (BLIN_GEN5 | BLIN_BIT6)
# define BLIN_GEN7    (BLIN_GEN6 | BLIN_BIT7)
# define BLIN_MASK    BLIN_GEN7
# define BLIN_TRAC    0x00800000
# if defined(BLIN_COMPAT2) || (defined(BLIN_COMPAT) && (BLIN_COMPAT <= 2))
/*                                                          for use in old style points of debugging */
#  define BLIN_VER1    BLIN_BIT0
#  define BLIN_VER2    BLIN_BIT1
#  define BLIN_VER3    BLIN_BIT2
#  define BLIN_VER4    BLIN_BIT3
#  define BLIN_VER5    BLIN_BIT4
#  define BLIN_VER6    BLIN_BIT5
#  define BLIN_VER7    BLIN_BIT6
#  define BLIN_VER8    BLIN_BIT7
#  define BLIN_VERMASK BLIN_MASK
# endif /* BLIN_COMPAT2 */
    int           err;
    struct {
        FILE     *file;              /*                     ,    fprintf() */
        u_int32_t what;              /*                                          */
                                     /*                sets by blin_ctl(BLIN_CTL_WHAT, BLIN_MODXXXX) */
# define BLIN_MODWARN  0x800000      /*                                 warn()  warnx() */
# define BLIN_MODPRNT  0x400000      /*                                 fprintf(.file, ) */
# define BLIN_MODLOGR  0x200000      /*                                  syslog(.prio, ) */

# define BLIN_MODEOAU  0x040000      /*                      \n,    */
# define BLIN_MODEOCR  0x020000      /*                                           \r   */
# define BLIN_MODEOLF  0x010000      /*                                           \n   */

# define BLIN_MODTIME  0x008000      /*                                                 */
# define BLIN_MODDREL  0x004000      /*                             blin_dumb */
# define BLIN_MODDNON  0x002000      /*                                       blin_dumb */
# define BLIN_MODDSTR  0x001000      /*                                      blin_dumb */
# define BLIN_MODDTXT  0x000010      /*                 blin_dumb()      */
        int32_t   prio;              /*                      ,    syslog() */
    }         w[8];
    int           tracfile;          /*                                      trace' */
# if BLINAP > 4
    int32_t       dummy0;
# endif
    void         *dummy1;
    void         *dummy2;
    void         *dummy3;
} blin_pamparam;

/*****************************************************************************************************/
/*                                                                                   BLIN procedures */
extern BLIN_flag blin_internal_flags;
extern u_int64_t blin_direct_flags;

const void   *blin_ctl    __P((u_int32_t ctl, ...));                     /* for ctl see man blin_ctl */
BLIN_flag     blin_doflag __P((u_int32_t mode, BLIN_flag w, BLIN_flag legal, BLIN_flag *f));
                                                     /* for mode see ctl of blin_ctl()               */
                                                     /* specifically all in 0x0000FF | BLIN_CTL_NONE */
int           blin_cry1   __P((int mode, const char *format, ...)) __printflike(2, 3);
int           blin_cry4   __P(( int         mode     /* mode & 0x0007 level, mode & 0x0008 use errno */
                              , const char *file
                              , const char *func
                              , int32_t     line
                              , const char *format
                              , ...
                             ))
                             __printflike(5, 6);
int           blin_64     __P((u_int64_t flags, const char * const *nm, int x, FILE *fo));
int           blin_dumb   __P((int mode, const void *buf, ssize_t len, ...));/* hex dump, mode level */

/*****************************************************************************************************/
                                     /*                         for blin_ctl() control 1st parameter */
# if defined(BLIN_COMPAT2) || (defined(BLIN_COMPAT) && (BLIN_COMPAT <= 2))
#  define BLIN_CTL_LEV0 BLIN_BIT0    /*                                            |          */
#  define BLIN_CTL_LEV1 BLIN_BIT1    /*                                            |          */
#  define BLIN_CTL_LEV2 BLIN_BIT2    /*                                            |       */
#  define BLIN_CTL_LEV3 BLIN_BIT3    /*                                            |        */
#  define BLIN_CTL_LEV4 BLIN_BIT4    /*                                            |         */
#  define BLIN_CTL_LEV5 BLIN_BIT5    /*                                            | BLIN_CTL_WHAT,  */
#  define BLIN_CTL_LEV6 BLIN_BIT6    /*                                            | BLIN_CTL_FILE   */
#  define BLIN_CTL_LEV7 BLIN_BIT7    /*                                            |  BLIN_CTL_PRIO */
#  define BLIN_CTL_LEVM BLIN_MASK    /*                        BLIN_CTL_LEV0 .. BLIN_CTL_LEV7*/
# endif /* BLIN_COMPAT2 */

/********* v only one of them v *********/
# define BLIN_CTL_OPER 0x00000F00    /*  ,     blin_pamparam_internal  */
                                     /**********   ,              */
# define BLIN_CTL_FLAG 0x00000000    /*   .flags                                          */
                                     /*    : FEQU, FSET, FRST, FXOR, NPRM, FAFM          */
                                     /*                  RISE, FNEG, NPRE, RMSK                      */
                                     /*                  NONE                                        */
                                     /*         : u_int32_t                    */
                                     /**********                                                     */
# define BLIN_CTL_WHAT 0x00000100    /*   .what                                           */
                                     /*    : BLIN_BIT*                                   */
                                     /*                  FEQU, FSET, FRST, FXOR, NPRM, FAFM          */
                                     /*                  FNEG, NPRE, RMSK                            */
                                     /*                  NONE                                        */
                                     /*         : u_int32_t                    */
                                     /**********                                                     */
# define BLIN_CTL_FILE 0x00000200    /*  .file,                   */
                                     /*    : BLIN_BIT*                                   */
                                     /*                  NPRE                                        */
                                     /*                  NONE                                        */
                                     /*         : FILE *                                  */
                                     /**********                                                     */
# define BLIN_CTL_PRIO 0x00000300    /*  .prio,                   */
                                     /*    : BLIN_BIT*                                   */
                                     /*                  NPRE                                        */
                                     /*                  NONE                                        */
                                     /*         : int32_t                            */
                                     /**********                                                     */
# define BLIN_CTL_DUMP 0x00000400    /*   blin_pamparam_internal  [0].file          */
                                     /**********                                                     */
# define BLIN_CTL_FNAM 0x00000500    /*   ,  .file,   .file */
                                     /*    : BLIN_BIT*                                   */
                                     /*                  NPRE                                        */
                                     /*                  NONE                                        */
                                     /*         : char *                              */
                                     /**********                                                     */
# define BLIN_CTL_FDES 0x00000600    /*  ,  .file,   .file*/
                                     /*    : BLIN_BIT*                                   */
                                     /*                  NPRE                                        */
                                     /*                  NONE                                        */
                                     /*         : int                          */
                                     /**********                                                     */
# define BLIN_CTL_TCFL 0x00000700    /*      .tracfile,  */
                                     /*    : NPRE                                        */
                                     /*                  NONE                                        */
                                     /*         : FILE *                                  */
                                     /**********                                                     */
# define BLIN_CTL_TCFN 0x00000800    /*   ,  .tracfile,     */
                                     /*    : NPRE                                        */
                                     /*                  NONE                                        */
                                     /*         : char *                              */
                                     /**********                                                     */
# define BLIN_CTL_TCFD 0x00000900    /*    .tracfile,           */
                                     /*    : NPRE                                        */
                                     /*                  NONE                                        */
                                     /*         : int                          */
                                     /**********                                                     */
# define BLIN_CTL_CPRI 0x00000D00    /*   ,  (C)                        */
                                     /**********                                                     */
# define BLIN_CTL_VERS 0x00000E00    /*   ,                           */
                                     /**********                                                     */
# define BLIN_CTL_RCSI 0x00000F00    /*   ,  RCS Id                              */
/********* ^ only one of them ^ *********/
/********* v only one of them v *********/
# define BLIN_CTL_FAFM 0x00000007    /*  ,                           */
# define BLIN_CTL_FEQU 0x00000000    /*                                 */
# define BLIN_CTL_FSET 0x00000001    /*                                */
# define BLIN_CTL_FRST 0x00000002    /*                                  */
# define BLIN_CTL_FXOR 0x00000003    /*                                  */
# define BLIN_CTL_NPRM 0x00000008    /*                                  */
/********* ^ only one of them ^ *********/

# define BLIN_CTL_RISE 0x00000010    /*                                         */
# define BLIN_CTL_FNEG 0x00000020    /*                                  */
# define BLIN_CTL_NPRE 0x00000040    /*   ,                       */
# define BLIN_CTL_RMSK 0x00000080    /*                                        */

# define BLIN_CTL_NONE 0x00010000    /*  ,                           */

# if defined(BLIN_COMPAT2) || (defined(BLIN_COMPAT) && (BLIN_COMPAT <= 2))
/*****************************************************************************************************/
/*                                                                old style to manipulate BLIN flags */
#  define kukBLIN_VERMASK(x)     (((BLIN_flag)(x) << 24) & BLIN_MASK)
#  define setBLIN_VERMASK(FL, x) do{(FL) &= ~BLIN_MASK; (FL) |= kukBLIN_VERMASK(x);} while (0)
#  define getBLIN_VERMASK(FL)    (((FL) >> 24) & (BLIN_MASK >> 24))
# endif /* BLIN_COMPAT2 */

/*****************************************************************************************************/
/*                                                                          to manipulate BLIN flags */
# define BLIN_VERBOSE(FL)                                                                             \
    do {                                                                                              \
        BLIN_flag *BLIN_temp = &(FL); *BLIN_temp |= (BLIN_flag)BLIN_I(blin_ctl( BLIN_CTL_FLAG         \
                                                                              | BLIN_CTL_RISE         \
                                                                              | BLIN_CTL_NPRE         \
                                                                              | BLIN_CTL_RMSK         \
                                                                              | BLIN_CTL_FEQU         \
                                                                              , *BLIN_temp            \
                                                                     )        );                      \
    } while(0)

# define BLIN_QUIET(FL)                                                                               \
    do { (FL) &= ~BLIN_MASK; blin_ctl(BLIN_CTL_FLAG | BLIN_CTL_FRST, BLIN_MASK);} while(0)

/*****************************************************************************************************/
/*                                   counts number of given args. if more than 63, 64-th is returned */
#define BLIN_NARG(...) BLIN_NARG_I("void", ## __VA_ARGS__, BLIN_RSEQ_N())
#define BLIN_NARG_I(...) BLIN_ARG_N(__VA_ARGS__) // needed to silence preprocessor
#define BLIN_ARG_N(  _0,  _1,  _2,  _3,  _4,  _5,  _6,  _7 \
                  ,  _8,  _9, _10, _11, _12, _13, _14, _15 \
                  , _16, _17, _18, _19, _20, _21, _22, _23 \
                  , _24, _25, _26, _27, _28, _29, _30, _31 \
                  , _32, _33, _34, _35, _36, _37, _38, _39 \
                  , _40, _41, _42, _43, _44, _45, _46, _47 \
                  , _48, _49, _50, _51, _52, _53, _54, _55 \
                  , _56, _57, _58, _59, _60, _61, _62, _63 \
                  ,   N, ... \
                  ) N
#define BLIN_RSEQ_N() \
          63, 62, 61, 60, 59, 58, 57, 56 \
        , 55, 54, 53, 52, 51, 50, 49, 48 \
        , 47, 46, 45, 44, 43, 42, 41, 40 \
        , 39, 38, 37, 36, 35, 34, 33, 32 \
        , 31, 30, 29, 28, 27, 26, 25, 24 \
        , 23, 22, 21, 20, 19, 18, 17, 16 \
        , 15, 14, 13, 12, 11, 10,  9,  8 \
        ,  7,  6,  5,  4,  3,  2,  1,  0

/*****************************************************************************************************/
/*                                          for use in printf of pointers on both 32 and 64 bit arch */
# ifdef __amd64__
#  define BLIN_D    "ld"     /*    */
#  define BLIN_U    "lu"     /*    */
#  define BLIN_P    "l"      /*    */
#  define BLIN_X    "012lX"  /*             */
#  define BLIN_O    "l"      /* offset, u_int64_t    */
#  define BLIN_I(I) ((u_int64_t)(I) & 0x0000FFFFFFFFFFFFUL)
# else /* !__amd64__ */
#  define BLIN_D    "d"      /*    */
#  define BLIN_U    "u"      /*    */
#  define BLIN_P    ""       /*    */
#  define BLIN_X    "08X"    /*             */
#  define BLIN_O    "ll"     /* offset, u_int64_t    */
#  define BLIN_I(I) ((u_int32_t)(I))
# endif /* __amd64__ */

/*****************************************************************************************************/
/*                                                                  for state mashine hard debugging */
# define BLIN_2STA24G (blin_statectl){{7, 1, 8, 24, ' ' , 5, 1, 0, 0}}
# define BLIN_2STA24E (blin_statectl){{7, 0, 8, 24, '\n', 5, 1, 0, 0}}
# define BLIN_2STO24G (blin_statectl){{7, 1, 8, 24, ' ' , 5, 1, 1, 0}}
# define BLIN_2STO24E (blin_statectl){{7, 0, 8, 24, '\n', 5, 1, 1, 0}}
# define BLIN_2STX24G (blin_statectl){{7, 1, 8, 24, ' ' , 5, 1, 0, 1}}
# define BLIN_2STX24E (blin_statectl){{7, 0, 8, 24, '\n', 5, 1, 0, 1}}

typedef union {
    struct {
        u_int32_t level : 3    /*                             */
                , gtequ : 1    /*   ,   >= bordsy,   bordsy    */
                , staten: 4    /*                  */
                , actinn: 8    /*                            */
                , bordsy: 8    /*  ,  gtequ                                         */
                , allign: 5    /*     allign              */
                , revert: 1    /*                               */
                , offsus: 1    /*  offset     in                  */
                , offmax: 1    /*  offset     in               */
        ;
    };
    u_int32_t statectl;
} blin_statectl;

int blin_statebody   __P(( blin_statectl  staflag
                         , const char     actnames[][3]  /*                     */
                         , const char     statenames[][3]/*                    */
                         , const char     clasnname[3]   /*                  */
                         , const char    *in             /*              */
                         , size_t         offset         /*       */
                         , u_int64_t      control        /*                  */
                         , u_int32_t      state          /*                         */
                         , u_int32_t      reg            /*   32        */
                         , u_char         byte           /*   8         */
                        ));
int blin_stateheader __P((blin_statectl staflag, const char actnames[][3]));

/*****************************************************************************************************/
/*                                                     for state mashine hard debugging BLIN_COMPAT2 */
# if defined(BLIN_COMPAT2) || (defined(BLIN_COMPAT) && (BLIN_COMPAT <= 2))
/* f   FILE       *file                                                                 */
/* n   const char *actnames[]                                                   */
/* r   u_char      byte            8                                    */
/* cn  const char *clasnname                                                 */
/* in  const char *in                                                                    */
/* q   size_t      offset                                         */
/* p   u_int32_t   reg             32                                   */
/* c   u_int64_t   control                                                   */
/* sn  const char *statenames[]                                                */
/* s   u_int32_t   state                                                            */
/* C   u_int64_t   C_state                          */
/* e                                                     */

#  ifdef ALLIGN_TABLE

#   define BLIN_STATEHEADER(f, n) \
{   int BLIN_STATEVAR_i;                                                                              \
    fprintf((f), "control-");                                                                         \
    for (BLIN_STATEVAR_i = 0; BLIN_STATEVAR_i < 24; BLIN_STATEVAR_i++)                                \
        if  ((n)[BLIN_STATEVAR_i][0] != '-') fprintf((f), "-%s", (n)[BLIN_STATEVAR_i]);               \
    fprintf((f), "nst vl cl st     p    --- q ---\n");                                                \
}

#   define BLIN_STATEBODY(f, n, r, cn, in, q, p, c, sn, s, C, e) \
{   int BLIN_STATEVAR_i, BLIN_STATEVAR_j, BLIN_STATEVAR_k;                                            \
    fprintf((f), "%08X ", (c));                                                                       \
    for ( BLIN_STATEVAR_i = 0, BLIN_STATEVAR_j = (c), BLIN_STATEVAR_k = 0                             \
        ; BLIN_STATEVAR_i < 24                                                                        \
        ; BLIN_STATEVAR_i++, BLIN_STATEVAR_j <<= 1                                                    \
        )                                                                                             \
        if  (((n)[BLIN_STATEVAR_i][0] != '-') || (BLIN_STATEVAR_j & 0x80000000))                      \
            fprintf( (f), "%s "                                                                       \
                   , (BLIN_STATEVAR_j & 0x80000000) ? (n)[BLIN_STATEVAR_i] : (u_char*)"  "            \
                   );                                                                                 \
    fprintf( (f), "%s %02X %s %s %08X %" BLIN_X "\t~"                                                 \
           , (sn)[(c) & (C)], (u_int)(r), (cn), (sn)[(s)], (u_int)(p), BLIN_I(q)                      \
           );                                                                                         \
    for ( BLIN_STATEVAR_i = 0; (in)[(q) + BLIN_STATEVAR_i] && (e); BLIN_STATEVAR_i++)                 \
        fprintf((f), "%c", (in)[(q) + BLIN_STATEVAR_i]);                                              \
    fprintf((f), "~\n");                                                                              \
}

#  else /* !ALLIGN_TABLE */

#   define BLIN_STATEHEADER(f, n) \
{   fprintf((f), "-------- control ------nst rs cl st     p    --- q ---\n");}

#   define BLIN_STATEBODY(f, n, r, cn, in, q, p, c, sn, s, C, e) \
{   int BLIN_STATEVAR_i, BLIN_STATEVAR_j, BLIN_STATEVAR_k;                                            \
    fprintf((f), "%08X ", (c));                                                                       \
    for ( BLIN_STATEVAR_i = 0, BLIN_STATEVAR_j = (c), BLIN_STATEVAR_k = 0                             \
        ; BLIN_STATEVAR_i < 24                                                                        \
        ; BLIN_STATEVAR_i++, BLIN_STATEVAR_j <<= 1                                                    \
        )                                                                                             \
        if  (BLIN_STATEVAR_j & 0x80000000) {                                                          \
            fprintf((f), "%s ", (n)[BLIN_STATEVAR_i]);                                                \
            BLIN_STATEVAR_k++;                                                                        \
        };                                                                                            \
    for (; BLIN_STATEVAR_k < 5; BLIN_STATEVAR_k++) fprintf((f), "   ");                               \
    fprintf((f), "%s %02X %s %s %08X %08X\t~", (sn)[(c) & (C)], (r), (cn), (sn)[(s)], (p), (q));      \
    for (BLIN_STATEVAR_i = 0; (in)[(q) + BLIN_STATEVAR_i] && (e); BLIN_STATEVAR_i++)                  \
        fprintf((f), "%c", (in)[(q) + BLIN_STATEVAR_i]);                                              \
    fprintf((f), "~\n");                                                                              \
}

#  endif /* ALLIGN_TABLE */
# endif /* BLIN_COMPAT2 */

/*****************************************************************************************************/
/*                                                                                              misc */
# ifndef BLIN_offset
#  define BLIN_offset(T, F) ((size_t)(&((T *)0)->F))
# endif /* BLIN_offset */

# ifdef BLIN_INTERNAL
#  define BLIN_MAININI    0x000001U
#  define BLIN_FLEGAL     (~BLIN_MAININI)
#  define BLIN_MIMASK(A)  (((u_int64_t)1 << A) - 1)
#  define BLIN_MAXTXTSTA  30U
#  define BLIN_MAXTXTDUM  88U
#  define BLIN_MAXSTRDUM  15U
#  define BLIN_MAXCRY1    256U
#  define BLIN_MAXCRY4    256U
#  define BLIN_TALLIGN    8U

typedef struct {
    u_int32_t     len;                /*                     */
    struct{
        int32_t   pid  : 24           /* pid                     */
                , erno : 8 ;          /* errno                                               */
    };
    u_int64_t     time;               /*              */
    struct{
        u_int32_t line  : 24          /*  ,              */
                , level : 8 ;         /*                              */
    };
    u_int8_t progsz;                  /* -      string     */
    u_int8_t filesz;                  /* -      string         */
    u_int8_t funcsz;                  /* -      string     */
    char string[1];                   /* _/_/_/         */
} BLIN_trace;

extern blin_pamparam blin_pamparam_internal;
size_t               blin_internal_strnlen __P((const char *s, size_t maxlen));

# endif

/*****************************************************************************************************/
/*                                                                                      BLIN_OSLinux */
#ifdef BLIN_OSLinux

# define EPROCUNAVAIL  EDOM
# define ENOATTR       ENXIO
# define EAUTH         EPERM
# define EFTYPE        EBADSLT
# define EPROGMISMATCH ELIBBAD
# define EDOOFUS       ENOTRECOVERABLE
# define O_EXLOCK      0              /* XXXX */
# define ARG_MAX       262144

# ifdef __STDC__
#  define __weak_reference(sym,alias)                   \
          __asm__(".weak " #alias);                     \
          __asm__(".equ "  #alias ", " #sym)
#  define __warn_references(sym,msg)                    \
          __asm__(".section .gnu.warning." #sym);       \
          __asm__(".asciz \"" msg "\"");                \
          __asm__(".previous")
#  define __sym_compat(sym,impl,verid)                  \
          __asm__(".symver " #impl ", " #sym "@" #verid)
#  define __sym_default(sym,impl,verid)                 \
          __asm__(".symver " #impl ", " #sym "@@" #verid)
# else
#  define __weak_reference(sym,alias)                   \
          __asm__(".weak alias");                       \
          __asm__(".equ alias, sym")
#  define __warn_references(sym,msg)                    \
          __asm__(".section .gnu.warning.sym");         \
          __asm__(".asciz \"msg\"");                    \
          __asm__(".previous")
#  define __sym_compat(sym,impl,verid)                  \
          __asm__(".symver impl, sym@verid")
#  define __sym_default(impl,sym,verid)                 \
          __asm__(".symver impl, sym@@verid")
# endif  /* __STDC__ */

extern const int          sys_nerr;
extern const char * const sys_errlist[];

const char *getprogname __P((void));
void       *reallocf    __P((void *ptr, size_t size));
char       *strnstr     __P((const char *s, const char *find, size_t slen));
int         fpurge      __P((FILE *stream));
size_t      strlcpy     __P((char * __restrict dst, const char * __restrict src, size_t dsize));
int         fdclose     __P((FILE *fp, int *fdp));
FILE       *funopen     __P(( void *cookie
                            , int   (*readfn) (void *,       char *, int)
                            , int   (*writefn)(void *, const char *, int)
                            , off_t (*seekfn) (void *, off_t       , int)
                            , int   (*closefn)(void *                   )
                           ));

#endif  /* BLIN_OSLinux */

/*****************************************************************************************************/
/*                                                                              proper redefenitions */

         float     babolo_strtof   __P((const char * restrict, const char ** restrict));
         double    babolo_strtod   __P((const char * restrict, const char ** restrict));
long     double    babolo_strtold  __P((const char * restrict, const char ** restrict));
unsigned long      babolo_strtoul  __P((const char * restrict, const char ** restrict, int));
unsigned long long babolo_strtoull __P((const char * restrict, const char ** restrict, int));
         long      babolo_strtol   __P((const char * restrict, const char ** restrict, int));
         long long babolo_strtoll  __P((const char * restrict, const char ** restrict, int));

__weak_reference(strtof  , babolo_strtof  );
__weak_reference(strtod  , babolo_strtod  );
__weak_reference(strtold , babolo_strtold );
__weak_reference(strtoul , babolo_strtoul );
__weak_reference(strtoull, babolo_strtoull);
__weak_reference(strtol  , babolo_strtol  );
__weak_reference(strtoll , babolo_strtoll );

# if defined(_INTTYPES_H_) || defined(_INTTYPES_H)

uintmax_t babolo_strtoumax(const char * restrict, const char ** restrict, int);
intmax_t  babolo_strtoimax(const char * restrict, const char ** restrict, int);

__weak_reference(strtoumax, babolo_strtoumax);
__weak_reference(strtoimax, babolo_strtoimax);

# endif

# if    (defined(BLIN_OSLinux) && defined(_STDLIB_H)) \
     || (defined(_SYS_TYPES_H_) && defined(_STDLIB_H_) && defined(_LIMITS_H_))

quad_t   babolo_strtoq (const char *, const char **, int);
u_quad_t babolo_strtouq(const char *, const char **, int);

__weak_reference(strtoq , babolo_strtoq );
__weak_reference(strtouq, babolo_strtouq);

# endif

__END_DECLS

#endif /* _BABOLO_BLINflag_H_ */
