# Copyright (C)2025 @BABOLO http://www.babolo.ru/
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#
# $Id: gnu.make,v 1.13 2025/11/20 05:34:31 babolo Exp $
#

.DEFAULT: all

.PHONY: doman gitup notify protover todo version test                       \
        subdir subdirinstall supdir supdirinstall ignore findiff            \
        all preall doall postall objnlib                                    \
        install preinstall doinstall postinstall                            \
        tarball pretarball dotarball posttarball                            \
        clean preclean doclean postclean cleacvs                            \
        release prerelease dorelease postrelease delrelease rerelease dotag

BLINUX	= .MAKE.MAKEFILE_PREFERENCE="BSDmakefile makefile Makefile" -DBLIN_OSLinux

ifdef PROTOVER
 TRANSFER	+= PROTOVER=${PROTOVER}
endif

ifdef DESTDIR
 TRANSFER	+= DESTDIR=${DESTDIR}
endif

all:
	+(export MAKEFLAGS=''; bmake ${TRANSFER} ${BLINUX} BLINUX='${BLINUX}' all)

version:
	+(export MAKEFLAGS=''; bmake ${TRANSFER} ${BLINUX} BLINUX='${BLINUX}' version)

ignore:
	+(export MAKEFLAGS=''; bmake ${TRANSFER} ${BLINUX} BLINUX='${BLINUX}' ignore)

findiff:
	+(export MAKEFLAGS=''; bmake ${TRANSFER} ${BLINUX} BLINUX='${BLINUX}' findiff)

install:
	+(export MAKEFLAGS=''; bmake ${TRANSFER} ${BLINUX} BLINUX='${BLINUX}' install)

tarball:
	+(export MAKEFLAGS=''; bmake ${TRANSFER} ${BLINUX} BLINUX='${BLINUX}' tarball)

clean:
	+(export MAKEFLAGS=''; bmake ${TRANSFER} ${BLINUX} BLINUX='${BLINUX}' clean)

cleacvs:
	+(export MAKEFLAGS=''; bmake ${TRANSFER} ${BLINUX} BLINUX='${BLINUX}' cleacvs)

test:
	+(export MAKEFLAGS=''; bmake ${TRANSFER} ${BLINUX} BLINUX='${BLINUX}' test)

required:
	+@(export MAKEFLAGS=''; bmake ${TRANSFER} ${BLINUX} BLINUX='${BLINUX}' required)
