/*-
 * Copyright (C)2020..2025 @BABOLO http://www.babolo.ru/
 * PKG = babolo-libmake
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2020..2025 @BABOLO http://www.babolo.ru/"
#ident "@(#) $Id: pout.c,v 1.21 2025/04/22 03:13:40 babolo Exp $"

#define Bpars_COMPAT  4
#define MULAR_COMPAT  0
#define MIFE_COMPAT   5
#define BLIN_COMPAT   VMAJOR
#define BLIN_INTERNAL

#include <sys/types.h>
#include <sys/event.h>
#include <sys/file.h>
#include <sysexits.h>
#include <string.h>
#include <stdlib.h>
#include <stdarg.h>
#include <stddef.h>
#include <limits.h>
#include <unistd.h>
#include <stdio.h>
#include <errno.h>
#include <time.h>
#include <err.h>
#include "../BLINflag.h"
#include <babolo/parser.h>
#include <multilar.h>
#include <mife.h>
#include "blinread.h"

int
BLINr_rp(BLINr_cfg *cfg, BLIN_trace *twind) {
#   define blin_internal_flags (cfg->flags & BLIN_MASK)
    BLINr_fraze      *curfraze;                /*                            */
    u_int8_t          termvar  = 0;            /*                     */
    u_int8_t          truvar   = 0;            /*                      */
    u_int64_t         fstime;                  /*    tracfile                    */
    time_t            htime;                   /*   stime                            */
    struct tm        *stime    = NULL;         /*      ISO        */
    int               ex       = EX_OK;        /*                                 */
    u_int32_t         p;                       /* ޣ,               */

    for (fstime = twind->time; ; twind = BLINr_next_wind(cfg)) {
        if  (!twind) {
            ifBLIN_QW0("tracefile window %"BLIN_O"d", cfg->tfile->ofpoint);
            ex = EX_IOERR;
            goto out;
        }
        ifBLIN_QX3( "twind={%u %u %d %"BLIN_O"u %d %u %u %u %u %u %.*s}"
                  , twind->len
                  , twind->level
                  , twind->pid
                  , twind->time
                  , twind->erno
                  , twind->line
                  , twind->progsz
                  , twind->filesz
                  , twind->funcsz
                  , (int)BLINr_slen(twind)
                  , (int)(twind->len - offsetof(BLIN_trace, string))
                  , twind->string
                  )
        ;
        ifBLIN_QO4
        blin_dumb( 4
                 , &twind->string[0]
                 , twind->len - offsetof(BLIN_trace, string)
                 )
        ;
        for (curfraze = cfg->filt; curfraze; curfraze = curfraze->next) {
            /*      BLINREAD_X */
            ifBLIN_QX3("curfraze %"BLIN_X, BLIN_I(curfraze));
            if  (!(curfraze->flags & BLINREAD_X)) {
                truvar = 0;
                termvar = 0;
            }
            ifBLIN_QX4("truvar %02X", truvar);
            if  (curfraze->time.from == curfraze->time.to) {
                truvar &= ~(termvar & BLINREAD_T);
            } else {
                BLINr_time *i;

                truvar  |= BLINREAD_T;
                termvar |= BLINREAD_T;
                for (p = curfraze->time.from; p < curfraze->time.to; ++p) {
                    if  (!(i = mular_getix(cfg->time, p))) {
                        ifBLIN_QW0("time getix(%u)", p);
                        ex = 1;
                        goto out;
                    }
                    ifBLIN_QX5( "mular_line(%u) %"BLIN_O"u-%"BLIN_O"u %d %d"
                              , p
                              , i->from
                              , i->to
                              , i->nrng
                              , i->abs
                              );
                    if  (  (!!i->nrng && (i->from == twind->time))
                        || (  !i->nrng
                           && ((i->from + (i->abs ? 0 : fstime)) <= twind->time)
                           && (twind->time <= (i->to + (i->abs ? 0 : fstime)))
                        )  ) {
                        truvar &= (u_int8_t)~BLINREAD_T;
                        break;
            }   }   }
            ifBLIN_QX4("truvar %02X", truvar);
            if  (curfraze->pid.from == curfraze->pid.to) {
                truvar &= ~(termvar & BLINREAD_I);
            } else {
                u_int32_t *i;

                truvar  |= BLINREAD_I;
                termvar |= BLINREAD_I;
                for (p = curfraze->pid.from; p < curfraze->pid.to; ++p) {
                    if  (!(i = mular_getix(cfg->pid, p))) {
                        ifBLIN_QW0("pid getix(%u)", p);
                        ex = 1;
                        goto out;
                    }
                    ifBLIN_QX5("mular_pid(%u) %u", p, *i);
                    if  (*i == (u_int32_t)twind->pid) {
                        truvar &= (u_int8_t)~BLINREAD_I;
                        break;
            }   }   }
            ifBLIN_QX4("truvar %02X", truvar);
            if  (curfraze->prog.from == curfraze->prog.to) {
                truvar &= ~(termvar & BLINREAD_R);
            } else {
                const char **i;

                truvar  |= BLINREAD_R;
                termvar |= BLINREAD_R;
                for (p = curfraze->prog.from; p < curfraze->prog.to; ++p) {
                    if  (!(i = mular_getix(cfg->prog, p))) {
                        ifBLIN_QW0("prog getix(%u)", p);
                        ex = 1;
                        goto out;
                    }
                    ifBLIN_QX5("mular_prog(%u) %zu %s", p, strlen(*i), *i);
                    if  (  (strlen(*i) == twind->progsz)
                        && !strncmp(*i, &twind->string[0], twind->progsz)
                        ) {
                        truvar &= (u_int8_t)~BLINREAD_R;
                        break;
            }   }   }
            ifBLIN_QX4("truvar %02X", truvar);
            if  (curfraze->file.from == curfraze->file.to) {
                truvar &= ~(termvar & BLINREAD_S);
            } else {
                const char **i;

                truvar  |= BLINREAD_S;
                termvar |= BLINREAD_S;
                ifBLIN_QX3( "%u %.*s"
                          , twind->filesz
                          , (int)twind->filesz
                          , &twind->string[twind->progsz]
                          )
                ;
                for (p = curfraze->file.from; p < curfraze->file.to; ++p) {
                    if  (!(i = mular_getix(cfg->file, p))) {
                        ifBLIN_QW0("file getix(%u)", p);
                        ex = 1;
                        goto out;
                    }
                    ifBLIN_QX5("mular_file(%u) %zu %s", p, strlen(*i), *i);
                    if  (  (strlen(*i) == twind->filesz)
                        && !strncmp(*i, &twind->string[twind->progsz], twind->filesz)
                        ) {
                        truvar &= (u_int8_t)~BLINREAD_S;
                        break;
            }   }   }
            ifBLIN_QX4("truvar %02X", truvar);
            if  (curfraze->func.from == curfraze->func.to) {
                truvar &= ~(termvar & BLINREAD_U);
            } else {
                const char **i;

                truvar  |= BLINREAD_U;
                termvar |= BLINREAD_U;
                for (p = curfraze->func.from; p < curfraze->func.to; ++p) {
                    if  (!(i = mular_getix(cfg->func, p))) {
                        ifBLIN_QW0("func getix(%u)", p);
                        ex = 1;
                        goto out;
                    }
                    ifBLIN_QX5("mular_func(%u) %zu %s", p, strlen(*i), *i);
                    if  (  (strlen(*i) == twind->funcsz)
                        && !strncmp( *i
                                   , &twind->string[twind->progsz + twind->filesz]
                                   , twind->funcsz
                        )          ) {
                        truvar &= (u_int8_t)~BLINREAD_U;
                        break;
            }   }   }
            ifBLIN_QX4("truvar %02X", truvar);
            if  (curfraze->line.from == curfraze->line.to) {
                truvar &= ~(termvar & BLINREAD_N);
            } else {
                BLINr_line *i;

                truvar  |= BLINREAD_N;
                termvar |= BLINREAD_N;
                for (p = curfraze->line.from; p < curfraze->line.to; ++p) {
                    if  (!(i = mular_getix(cfg->line, p))) {
                        ifBLIN_QW0("line getix(%u)", p);
                        ex = 1;
                        goto out;
                    }
                    ifBLIN_QX5("mular_line(%u) %d-%d %d", p, i->from, i->to, i->nrng);
                    if  ( i->nrng
                        ? (i->from == twind->line)
                        : ((i->from <= twind->line) && (twind->line <= i->to))
                        ) {
                        truvar &= (u_int8_t)~BLINREAD_N;
                        break;
            }   }   }
            ifBLIN_QX4("truvar %02X", truvar);
            if  (!curfraze->levfl) {
                truvar &= ~(termvar & BLINREAD_L);
            } else {
                truvar  |= BLINREAD_L;
                termvar |= BLINREAD_L;
                if  (curfraze->level & (1U << twind->level)) truvar &= (u_int8_t)~BLINREAD_L;
            }
            truvar ^= curfraze->flags & BLINREAD_M;
            ifBLIN_QX3("truvar %02X, inv %02X", truvar, curfraze->flags & BLINREAD_M);
            if  (truvar == 0) break;
        }
        if  (truvar == 0) {
            if  (cfg->flags & BLINREAD_P_I) printf("%d ", twind->pid);
            if  (cfg->flags & BLINREAD_P_T) {
                printf( "%04"BLIN_O"u.%09u "
                      , (twind->time - fstime) / BLINr_E9
                      , (u_int32_t)((twind->time - fstime) % BLINr_E9)
                      )
                ;
            } else if  (cfg->flags & BLINREAD_P_D) {
                htime = (time_t)(twind->time / BLINr_E9);
                stime = localtime(&htime);
                printf( "%d-%02d-%02d_%02d:%02d:%02d.%09u "
                      , stime->tm_year + 1900
                      , stime->tm_mon + 1
                      , stime->tm_mday
                      , stime->tm_hour
                      , stime->tm_min
                      , stime->tm_sec
                      , (u_int32_t)(twind->time % BLINr_E9)
                      )
                ;
            }
            if  (cfg->flags & BLINREAD_P_L) printf("%u ", twind->level);
            if  (cfg->flags & BLINREAD_P_E) printf("%d ", twind->erno);
            if  (cfg->flags & BLINREAD_P_R) printf("%.*s:", twind->progsz, twind->string);
            if  (cfg->flags & BLINREAD_P_S) {
                printf("%.*s:", twind->filesz, &twind->string[twind->progsz]);
            }
            if  (cfg->flags & BLINREAD_P_U) {
                printf( "%.*s:"
                      , twind->funcsz
                      , &twind->string[twind->progsz + twind->filesz]
                      )
                ;
            }
            if  (cfg->flags & BLINREAD_P_N) printf("%d:", twind->line);
            for ( p = 0
                ; twind->string[BLINr_slen(twind) - 1 - p] == '\n'
                ; p++
                ) {}
            printf( " %.*s\n"
                  , (int)( BLINr_slen(twind) - twind->progsz - twind->filesz - twind->funcsz - p)
                  , &twind->string[twind->progsz + twind->filesz + twind->funcsz]
                  )
            ;
        }
        if  (mife_ctlsize(cfg->tfile) == (ssize_t)twind->len) break;
    }
out:
    return(ex);
#   undef blin_internal_flags
}
